/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units;

import com.pnfsoftware.jeb.core.units.IUnitNotification;
import com.pnfsoftware.jeb.core.units.IUnitNotificationManager;
import com.pnfsoftware.jeb.core.units.UnitNotification;
import com.pnfsoftware.jeb.util.collect.SynchronizedLinkedMap;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerVersion;
import java.util.Collection;
import java.util.List;

@Ser
@SerVersion(value=1)
public class UnitNotificationManager
implements IUnitNotificationManager {
    @SerId(value=1)
    private List<IUnitNotification> notifications;
    @SerId(value=2, version=1)
    private SynchronizedLinkedMap<String, IUnitNotification> map = new SynchronizedLinkedMap();

    @SerCustomInitPostGraph
    private void init() {
        if (this.notifications != null) {
            this.map = new SynchronizedLinkedMap();
            for (IUnitNotification iUnitNotification : this.notifications) {
                this.addNotification(new UnitNotification(iUnitNotification));
            }
            this.notifications = null;
        }
    }

    @Override
    public List<? extends IUnitNotification> getNotifications() {
        return this.map.copyOfValues();
    }

    @Override
    public int getNotificationCount() {
        return this.map.size();
    }

    @Override
    public void addNotification(IUnitNotification iUnitNotification) {
        this.map.put(iUnitNotification.getKey(), iUnitNotification);
    }

    @Override
    public void addNotifications(Collection<? extends IUnitNotification> collection) {
        for (IUnitNotification iUnitNotification : collection) {
            this.addNotification(iUnitNotification);
        }
    }

    @Override
    public boolean removeNotification(String string) {
        return this.map.remove(string) != null;
    }

    @Override
    public IUnitNotification getNotification(String string) {
        return this.map.get(string);
    }
}

