/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.text.impl;

import com.pnfsoftware.jeb.core.input.FileInputRegionInformation;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.input.IInputLocation;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.text.IAnchor;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.AbstractTextDocument;
import com.pnfsoftware.jeb.core.output.text.impl.Anchor;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.output.text.impl.Line;
import com.pnfsoftware.jeb.core.output.text.impl.TextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.TextItem;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;

@SerDisabled
public class HexDumpDocument
extends AbstractTextDocument {
    private static final ILogger logger = GlobalLog.getLogger(HexDumpDocument.class);
    private static int bytesPerAnchor = 16;
    private static int bytesPerLine = 16;
    private IInput input;
    private IUnit unit;
    private long docsize;
    private int addrCharLen;
    private long anchorRange;
    private SeekableByteChannel channel;
    private ByteBuffer tempBuffer = ByteBuffer.allocate(1);

    public HexDumpDocument(IInput iInput, IUnit iUnit) {
        this.input = iInput;
        this.unit = iUnit;
        this.docsize = iInput.getCurrentSize();
        this.addrCharLen = this.docsize <= Integer.MAX_VALUE ? 8 : 16;
        this.anchorRange = (this.docsize + (long)bytesPerLine - 1L) / (long)bytesPerLine;
        try {
            this.channel = iInput.getChannel();
        }
        catch (IOException iOException) {
            logger.catching(iOException);
        }
    }

    public HexDumpDocument(IInput iInput) {
        this(iInput, null);
    }

    @Override
    public void dispose() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                logger.catching(iOException);
            }
            this.channel = null;
        }
    }

    public IInput getInput() {
        return this.input;
    }

    private byte readByte(long l2) throws InterruptedException {
        return this.readByte(l2, true);
    }

    private byte readByte(long l2, boolean bl2) throws InterruptedException {
        if (this.channel == null) {
            return 0;
        }
        try {
            this.channel.position(l2);
            this.tempBuffer.clear();
            this.channel.read(this.tempBuffer);
            return this.tempBuffer.get(0);
        }
        catch (IOException iOException) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Thread is interrupted");
            }
            if (bl2) {
                try {
                    this.channel = this.input.getChannel();
                }
                catch (IOException iOException2) {
                    logger.error("Input is no more readable. Was it deleted or moved?", new Object[0]);
                    logger.catching(iOException2);
                    throw new InterruptedException("Input can not be found anymore");
                }
                return this.readByte(l2, false);
            }
            logger.i("Can not read byte at %xh", l2);
            logger.catching(iOException);
            return 0;
        }
    }

    @Override
    public long getAnchorCount() {
        return this.anchorRange;
    }

    @Override
    public ITextDocumentPart getDocumentPart(long l2, int n, int n2) {
        long l3;
        long l4;
        if (n2 < 100) {
            n2 = 100;
        }
        if (n < 600) {
            n = 600;
        }
        if ((l4 = l2 - (long)n2) < 0L) {
            l4 = 0L;
        }
        if ((l3 = l2 + (long)n) > this.anchorRange) {
            l3 = this.anchorRange;
        }
        ArrayList<ILine> arrayList = new ArrayList<ILine>();
        ArrayList<IAnchor> arrayList2 = new ArrayList<IAnchor>();
        while (l4 < l3) {
            int n3;
            long l5 = l4 * (long)bytesPerLine;
            int n4 = bytesPerLine;
            if (l5 > this.docsize) {
                arrayList2.add(new Anchor(l4, arrayList.size()));
                arrayList.add(new Line(""));
                ++l4;
                continue;
            }
            if (l5 + (long)n4 > this.docsize) {
                n4 = (int)(this.docsize - l5);
            }
            ArrayList<TextItem> arrayList3 = new ArrayList<TextItem>();
            StringBuilder stringBuilder = new StringBuilder();
            arrayList3.add(new TextItem(stringBuilder.length(), this.addrCharLen, ItemClassIdentifiers.ADDRESS));
            if (this.addrCharLen == 8) {
                stringBuilder.append(Formatter.toHexString(l5, true, 8)).append("  ");
            } else if (this.addrCharLen == 16) {
                stringBuilder.append(Formatter.toHexString(l5, true, 16)).append("  ");
            } else if (this.addrCharLen == 17) {
                stringBuilder.append(Formatter.toHexString(l5 >> 32 & 0xFFFFFFFFFFFFFFFFL, true, 8)).append("'");
                stringBuilder.append(Formatter.toHexString(l5 & 0xFFFFFFFFFFFFFFFFL, true, 8)).append("  ");
            } else {
                throw new RuntimeException();
            }
            byte[] byArray = new byte[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                try {
                    byArray[n3] = this.readByte(l5 + (long)n3);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                arrayList3.add(new TextItem(stringBuilder.length(), 2, ItemClassIdentifiers.TYPE_BYTE));
                stringBuilder.append(Formatter.toHexString(byArray[n3] & 0xFF, true, 2)).append(" ");
            }
            int n5 = n3;
            while (n3 < 16) {
                stringBuilder.append("   ");
                ++n3;
            }
            stringBuilder.append(" ");
            for (n3 = 0; n3 < n5; ++n3) {
                arrayList3.add(new TextItem(stringBuilder.length(), 1, ItemClassIdentifiers.TYPE_BYTE));
                if (byArray[n3] >= 32 && byArray[n3] < 127) {
                    stringBuilder.append((char)byArray[n3]);
                    continue;
                }
                stringBuilder.append(".");
            }
            String string = stringBuilder.toString();
            arrayList2.add(new Anchor(l4, arrayList.size()));
            arrayList.add(new Line(string, arrayList3));
            ++l4;
        }
        return new TextDocumentPart(arrayList, arrayList2);
    }

    @Override
    public String coordinatesToAddress(ICoordinates iCoordinates, AddressConversionPrecision addressConversionPrecision) {
        long l2;
        long l3 = iCoordinates.getAnchorId() * (long)bytesPerAnchor + (long)(iCoordinates.getLineDelta() * bytesPerLine);
        int n = iCoordinates.getColumnOffset();
        if (n < this.addrCharLen + 2 || n >= this.addrCharLen + 67 || n == this.addrCharLen + 50) {
            return null;
        }
        if (n >= this.addrCharLen + 51) {
            l2 = l3 + (long)(n - (this.addrCharLen + 51));
        } else {
            int n2 = (n - (this.addrCharLen + 2)) % 3;
            if (n2 == 2) {
                return null;
            }
            l2 = l3 + (long)((n - (this.addrCharLen + 2)) / 3);
        }
        if (l2 > this.docsize) {
            l2 = this.docsize;
        }
        return String.format("@%Xh", l2);
    }

    @Override
    public ICoordinates addressToCoordinates(String string) {
        IInputLocation iInputLocation;
        if (string == null || string.isEmpty()) {
            return null;
        }
        long l2 = -1L;
        if (string.charAt(0) != '@' && this.unit instanceof IInteractiveUnit && (iInputLocation = ((IInteractiveUnit)this.unit).addressToLocation(string)) instanceof FileInputRegionInformation) {
            l2 = ((FileInputRegionInformation)iInputLocation).getOffset();
        }
        if (l2 == -1L) {
            if (string.charAt(0) == '@') {
                string = string.substring(1);
            }
            l2 = Conversion.stringToLong(string, -1L);
        }
        if (l2 < 0L || l2 > this.docsize) {
            return null;
        }
        return new Coordinates(l2 / (long)bytesPerLine, 0, (int)((long)(this.addrCharLen + 2) + 3L * (l2 % (long)bytesPerLine)));
    }
}

