/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.text;

import com.pnfsoftware.jeb.core.output.text.IAnchor;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.ITextItem;
import com.pnfsoftware.jeb.util.base.CharSequenceList;
import com.pnfsoftware.jeb.util.format.CharSequences;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TextPartUtil {
    private static final ILogger logger = GlobalLog.getLogger(TextPartUtil.class);

    public static void verifyPart(ITextDocumentPart iTextDocumentPart) {
        Object object;
        int n;
        List<? extends IAnchor> list = iTextDocumentPart.getAnchors();
        int n2 = list.size();
        List<? extends ILine> list2 = iTextDocumentPart.getLines();
        int n3 = list2.size();
        if (n2 == 0) {
            throw new RuntimeException("Part without anchor");
        }
        Object object2 = list.get(0);
        if (object2.getLineIndex() != 0) {
            throw new RuntimeException("The first anchor in the part does not reference first line in the part: " + object2.getLineIndex());
        }
        for (n = 1; n < n2; ++n) {
            object = list.get(n);
            if (object.getIdentifier() <= object2.getIdentifier() || object.getLineIndex() <= object2.getLineIndex()) {
                throw new RuntimeException(String.format("Non strictly ascending anchors: (%d,%d) vs (%d,%d) ", object2.getIdentifier(), object2.getLineIndex(), object.getIdentifier(), object.getLineIndex()));
            }
            if (object.getLineIndex() > n3) {
                throw new RuntimeException(String.format("Invalid line index: %d vs %d", n3, object.getLineIndex()));
            }
            object2 = object;
        }
        for (n = 0; n < n3; ++n) {
            object = iTextDocumentPart.getLines().get(n);
            CharSequence charSequence = object.getText();
            if (CharSequences.indexOf2(charSequence, '\r', '\n') >= 0) {
                throw new RuntimeException(String.format("Lines within a document part must not contain new-line characters @[%d]", n));
            }
            int n4 = 0;
            for (ITextItem iTextItem : object.getItems()) {
                int n5 = iTextItem.getOffset();
                if (n5 < n4) {
                    throw new RuntimeException(String.format("Items in a document part must not overlap or be out-of-bound @[%d , %d]", n, n5));
                }
                int n6 = iTextItem.getLength();
                int n7 = n5 + n6;
                if (n7 > charSequence.length()) {
                    logger.debug("Item out of bound @[%d , %d]", n, n5);
                    throw new RuntimeException(String.format("Items in a document part must not be out-of-bound @[%d , %d]", n, n5));
                }
                n4 = n7;
            }
        }
    }

    public static IAnchor getFirstAnchor(ITextDocumentPart iTextDocumentPart) {
        if (iTextDocumentPart == null) {
            return null;
        }
        int n = iTextDocumentPart.getAnchors().size();
        if (n == 0) {
            return null;
        }
        return iTextDocumentPart.getAnchors().get(0);
    }

    public static long getFirstAnchorId(ITextDocumentPart iTextDocumentPart) {
        int n = iTextDocumentPart.getAnchors().size();
        if (n == 0) {
            return -1L;
        }
        return iTextDocumentPart.getAnchors().get(0).getIdentifier();
    }

    public static IAnchor getLastAnchor(ITextDocumentPart iTextDocumentPart) {
        if (iTextDocumentPart == null) {
            return null;
        }
        int n = iTextDocumentPart.getAnchors().size();
        if (n == 0) {
            return null;
        }
        IAnchor iAnchor = iTextDocumentPart.getAnchors().get(n - 1);
        if (iAnchor.getLineIndex() == iTextDocumentPart.getLines().size()) {
            if (n == 1) {
                return null;
            }
            iAnchor = iTextDocumentPart.getAnchors().get(n - 2);
        }
        return iAnchor;
    }

    public static long getLastAnchorId(ITextDocumentPart iTextDocumentPart) {
        IAnchor iAnchor = TextPartUtil.getLastAnchor(iTextDocumentPart);
        if (iAnchor == null) {
            return -1L;
        }
        return iAnchor.getIdentifier();
    }

    public static long getNextAnchorId(ITextDocumentPart iTextDocumentPart) {
        int n = iTextDocumentPart.getAnchors().size();
        if (n == 0) {
            return -1L;
        }
        IAnchor iAnchor = iTextDocumentPart.getAnchors().get(n - 1);
        if (iAnchor.getLineIndex() == iTextDocumentPart.getLines().size()) {
            return iAnchor.getIdentifier();
        }
        return iAnchor.getIdentifier() + 1L;
    }

    public static List<ITextItem> getItems(ITextDocumentPart iTextDocumentPart) {
        ArrayList<ITextItem> arrayList = new ArrayList<ITextItem>();
        for (ILine iLine : iTextDocumentPart.getLines()) {
            arrayList.addAll(iLine.getItems());
        }
        return arrayList;
    }

    public static ITextItem getItemAt(ITextDocumentPart iTextDocumentPart, int n, int n2) {
        if (n < 0 || n >= iTextDocumentPart.getLines().size()) {
            return null;
        }
        return TextPartUtil.getItemAt(iTextDocumentPart.getLines().get(n), n2);
    }

    public static ITextItem getItemAt(ILine iLine, int n) {
        ITextItem iTextItem;
        int n2;
        Iterator<? extends ITextItem> iterator = iLine.getItems().iterator();
        while (iterator.hasNext() && n >= (n2 = (iTextItem = iterator.next()).getOffset())) {
            if (n >= n2 + iTextItem.getLength()) continue;
            return iTextItem;
        }
        return null;
    }

    public static String buildRawTextFromPart(ITextDocumentPart iTextDocumentPart) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        for (ILine iLine : iTextDocumentPart.getLines()) {
            CharSequence charSequence = iLine.getText();
            arrayList.add(charSequence);
        }
        return new CharSequenceList(arrayList).toString();
    }

    public static String buildRawTextFromPartInterruptibly(ITextDocumentPart iTextDocumentPart) throws InterruptedException {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        int n = 0;
        for (ILine iLine : iTextDocumentPart.getLines()) {
            CharSequence charSequence = iLine.getText();
            arrayList.add(charSequence);
            if (++n % 1000 != 0 || !Thread.interrupted()) continue;
            throw new InterruptedException("The text part generation was interrupted");
        }
        return new CharSequenceList(arrayList).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static List<? extends ILine> getLinesOfAnchor(ITextDocumentPart iTextDocumentPart, long l2) {
        void var6_9;
        List<? extends IAnchor> list = iTextDocumentPart.getAnchors();
        int n = 0;
        for (IAnchor iAnchor : list) {
            if (iAnchor.getIdentifier() == l2) break;
            ++n;
        }
        if (n >= list.size()) {
            return null;
        }
        int n2 = list.get(n).getLineIndex();
        if (n + 1 >= list.size()) {
            int n3 = iTextDocumentPart.getLines().size();
        } else {
            int n3 = list.get(n + 1).getLineIndex();
        }
        return iTextDocumentPart.getLines().subList(n2, (int)var6_9);
    }

    public static ILine getLineAt(ITextDocumentPart iTextDocumentPart, ICoordinates iCoordinates) {
        List<? extends ILine> list = TextPartUtil.getLinesOfAnchor(iTextDocumentPart, iCoordinates.getAnchorId());
        if (list != null && iCoordinates.getLineDelta() < list.size()) {
            return list.get(iCoordinates.getLineDelta());
        }
        return null;
    }

    public static IAnchor getAnchorAtLine(ITextDocumentPart iTextDocumentPart, int n) {
        IAnchor iAnchor = null;
        for (IAnchor iAnchor2 : iTextDocumentPart.getAnchors()) {
            if (n < iAnchor2.getLineIndex()) break;
            iAnchor = iAnchor2;
        }
        return iAnchor;
    }

    public static boolean isInsidePart(ITextDocumentPart iTextDocumentPart, ICoordinates iCoordinates) {
        IAnchor iAnchor = TextPartUtil.getAnchorById(iTextDocumentPart, iCoordinates.getAnchorId());
        if (iAnchor == null) {
            return false;
        }
        int n = iAnchor.getLineIndex() + iCoordinates.getLineDelta();
        if (n < 0 || n >= iTextDocumentPart.getLines().size()) {
            return false;
        }
        ILine iLine = iTextDocumentPart.getLines().get(n);
        int n2 = iCoordinates.getColumnOffset();
        return n2 >= 0 && n2 <= iLine.getText().length();
    }

    public static int coordinatesToLineIndex(ITextDocumentPart iTextDocumentPart, ICoordinates iCoordinates) {
        int n;
        if (iCoordinates == null) {
            return -1;
        }
        IAnchor iAnchor = TextPartUtil.getAnchorById(iTextDocumentPart, iCoordinates.getAnchorId());
        if (iAnchor == null) {
            if (iCoordinates.getAnchorId() > TextPartUtil.getFirstAnchorId(iTextDocumentPart) && iCoordinates.getAnchorId() < TextPartUtil.getLastAnchorId(iTextDocumentPart)) {
                iAnchor = TextPartUtil.getApproximateAnchorById(iTextDocumentPart, iCoordinates.getAnchorId(), -1);
            } else {
                return -1;
            }
        }
        if ((n = iAnchor.getLineIndex() + iCoordinates.getLineDelta()) < 0 || n >= iTextDocumentPart.getLines().size()) {
            return -1;
        }
        return n;
    }

    public static IAnchor getAnchorById(ITextDocumentPart iTextDocumentPart, long l2) {
        for (IAnchor iAnchor : iTextDocumentPart.getAnchors()) {
            long l3 = iAnchor.getIdentifier();
            if (l3 == l2) {
                return iAnchor;
            }
            if (l3 <= l2) continue;
            break;
        }
        return null;
    }

    public static IAnchor getNearestAnchorById(ITextDocumentPart iTextDocumentPart, long l2) {
        return TextPartUtil.getApproximateAnchorById(iTextDocumentPart, l2, 0);
    }

    public static IAnchor getApproximateAnchorById(ITextDocumentPart iTextDocumentPart, long l2, int n) {
        int n2;
        List<? extends IAnchor> list = iTextDocumentPart.getAnchors();
        IAnchor iAnchor = null;
        long l3 = -1L;
        for (n2 = 0; n2 < list.size() && (l3 = (iAnchor = list.get(n2)).getIdentifier()) < l2; ++n2) {
        }
        if (iAnchor == null) {
            return null;
        }
        if (l3 == l2) {
            return iAnchor;
        }
        if (n2 >= list.size() || n2 == 0) {
            return null;
        }
        if (n > 0) {
            return iAnchor;
        }
        IAnchor iAnchor2 = list.get(n2 - 1);
        if (n < 0) {
            return iAnchor2;
        }
        long l4 = l3 - l2;
        long l5 = l2 - iAnchor2.getIdentifier();
        if (l4 <= l5) {
            return iAnchor;
        }
        return iAnchor2;
    }

    public static boolean isAnchorDisplayed(ITextDocumentPart iTextDocumentPart, long l2) {
        return TextPartUtil.getAnchorById(iTextDocumentPart, l2) != null;
    }
}

