/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.text;

import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.util.format.Strings;

public class TextDocumentUtil {
    public static String getText(ITextDocument iTextDocument) {
        return TextDocumentUtil.buildText(iTextDocument).toString();
    }

    public static StringBuilder buildText(ITextDocument iTextDocument) {
        return TextDocumentUtil.buildText(iTextDocument, 100000000);
    }

    public static StringBuilder buildText(ITextDocument iTextDocument, int n) {
        long l2 = iTextDocument.getFirstAnchor();
        ITextDocumentPart iTextDocumentPart = iTextDocument.getDocumentPart(l2, n);
        if (iTextDocumentPart == null) {
            throw new RuntimeException("The part could not be retrieved");
        }
        if (iTextDocumentPart.getLines().size() > n) {
            throw new RuntimeException("The document contains too many lines");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ILine iLine : iTextDocumentPart.getLines()) {
            stringBuilder.append(iLine.getText());
            stringBuilder.append(Strings.LINESEP);
        }
        return stringBuilder;
    }
}

