/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.input;

import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.DeserializerHelper;
import com.pnfsoftware.jeb.util.serialization.SerializerHelper;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomRead;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomWrite;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.List;

@Ser
public class FileInput
implements IInput {
    private static final ILogger logger = GlobalLog.getLogger(FileInput.class);
    @SerTransient
    private String path;
    @SerTransient
    private File file;
    @SerTransient
    private ByteBuffer hdr;
    @SerTransient
    private List<InputStream> inputStreams = new ArrayList<InputStream>();

    @SerCustomWrite
    private void save(SerializerHelper serializerHelper) throws IOException {
        String string = this.file == null ? this.path : this.file.getCanonicalPath();
        serializerHelper.write(string);
    }

    @SerCustomRead
    private void load(DeserializerHelper deserializerHelper) throws IOException {
        this.path = (String)deserializerHelper.read();
        this.inputStreams = new ArrayList<InputStream>();
        File file = new File(this.path);
        if (!file.isFile() && !(file = new File(IO.getCwd(), file.getName())).isFile()) {
            file = null;
        }
        if (file == null) {
            logger.error("An input file was not found: %s", this.path);
            return;
        }
        if (!file.canRead()) {
            logger.error("An input file cannot be read: %s", this.path);
            return;
        }
        this.setup(file);
    }

    public FileInput(File file) throws IOException {
        this.path = file.getCanonicalPath();
        this.setup(file);
    }

    private void setup(File file) throws IOException {
        this.file = file;
        try (FileInputStream fileInputStream = new FileInputStream(file);
             FileChannel fileChannel = fileInputStream.getChannel();){
            this.hdr = ByteBuffer.allocate(512);
            fileChannel.read(this.hdr);
            this.hdr.position(0);
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) throws IOException {
        if (this.file != null) {
            throw new IOException("A file is already connctd to this input object");
        }
        this.setup(file);
    }

    @Override
    public void close() {
        for (InputStream inputStream : this.inputStreams) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public long getCurrentSize() {
        if (this.file == null) {
            return 0L;
        }
        return this.file.length();
    }

    @Override
    public ByteBuffer getHeader() {
        if (this.file == null) {
            return null;
        }
        return this.hdr.asReadOnlyBuffer();
    }

    @Override
    public SeekableByteChannel getChannel() throws IOException {
        if (this.file == null) {
            throw new IOException("The file does not exist: " + this.file);
        }
        FileInputStream fileInputStream = new FileInputStream(this.file);
        this.inputStreams.add(fileInputStream);
        return fileInputStream.getChannel();
    }

    @Override
    public InputStream getStream() throws IOException {
        if (this.file == null) {
            throw new IOException("The file does not exist: " + this.file);
        }
        FileInputStream fileInputStream = new FileInputStream(this.file);
        this.inputStreams.add(fileInputStream);
        return fileInputStream;
    }
}

