/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.events;

import com.pnfsoftware.jeb.core.properties.IPropertyDefinition;
import java.util.ArrayList;
import java.util.List;

public class PropertyChangeNotification {
    List<Entry> entries = new ArrayList<Entry>();

    public PropertyChangeNotification() {
    }

    public PropertyChangeNotification(String string, Object object, IPropertyDefinition iPropertyDefinition) {
        this.add(string, object, iPropertyDefinition);
    }

    public void add(String string, Object object, IPropertyDefinition iPropertyDefinition) {
        this.entries.add(new Entry(string, object, iPropertyDefinition));
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public boolean has(String ... stringArray) {
        if (stringArray.length > 0) {
            for (Entry entry : this.entries) {
                for (String string : stringArray) {
                    if (!entry.getPropertyFullyQualifiedName().equals(string)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        return this.entries.toString();
    }

    public static class Entry {
        String propfqn;
        Object value;
        IPropertyDefinition pd;

        public Entry(String string, Object object, IPropertyDefinition iPropertyDefinition) {
            if (string == null || !string.startsWith(".")) {
                throw new IllegalArgumentException("Invalid property FQN: " + string);
            }
            this.propfqn = string;
            this.value = object;
            this.pd = iPropertyDefinition;
        }

        public String getPropertyFullyQualifiedName() {
            return this.propfqn;
        }

        public Object getUpdatedValue() {
            return this.value;
        }

        public IPropertyDefinition getPropertyDefinition() {
            return this.pd;
        }

        public String toString() {
            return String.format("%s->%s(def:%s)", this.propfqn, this.value, this.pd);
        }
    }
}

