/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core;

import com.pnfsoftware.jeb.core.CoreOptions;
import com.pnfsoftware.jeb.core.ICoreContext;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.events.ExceptionNotification;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.events.TelemetryNotification;
import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jebglobal.GW;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JebCoreService {
    public static ICoreContext getExistingInstance() {
        return GW.Le();
    }

    public static ICoreContext getInstance() throws JebException {
        return GW.eO();
    }

    public static ICoreContext getInstance(String string) throws JebException {
        return GW.eO(string, null);
    }

    public static ICoreContext getInstance(String string, CoreOptions coreOptions) throws JebException {
        return GW.eO(string, coreOptions);
    }

    public static IEnginesContext getDefaultEnginesContext() {
        return JebCoreService.getExistingInstance().getDefaultEnginesContexts();
    }

    public static void notifyExceptionToClient(Throwable throwable, int n, Map<String, Object> map) {
        if (throwable == null) {
            return;
        }
        try {
            JebCoreService.getInstance().notifyListeners(new JebEvent(J.Notification, new ExceptionNotification(throwable, null, n, map)));
        }
        catch (JebException jebException) {
            // empty catch block
        }
    }

    public static void notifyExceptionToClient(Throwable throwable) {
        JebCoreService.notifyExceptionToClient(throwable, 0, null);
    }

    public static void notifySilentExceptionToClient(Throwable throwable) {
        JebCoreService.notifyExceptionToClient(throwable, 1, null);
    }

    public static void notifySilentExceptionToClient(Throwable throwable, Map<String, Object> map) {
        JebCoreService.notifyExceptionToClient(throwable, 1, map);
    }

    public static void silentExcept(Throwable throwable) {
        JebCoreService.notifySilentExceptionToClient(throwable);
    }

    public static void notifyTelemetryToClient(String string, Map<String, String> map) {
        if (string == null) {
            return;
        }
        try {
            if (map == null) {
                map = Collections.emptyMap();
            }
            JebCoreService.getInstance().notifyListeners(new JebEvent(J.Notification, new TelemetryNotification(string, map)));
        }
        catch (JebException jebException) {
            // empty catch block
        }
    }

    public static void notifyTelemetryToClient(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        JebCoreService.notifyTelemetryToClient(string, hashMap);
    }

    public static void notifyTelemetryToClient(String string, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string2, string3);
        JebCoreService.notifyTelemetryToClient(string, hashMap);
    }

    public static void notifyTelemetryToClient(String string, String string2, String string3, String string4, String string5) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string2, string3);
        hashMap.put(string4, string5);
        JebCoreService.notifyTelemetryToClient(string, hashMap);
    }
}

