/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.script;

import com.pnfsoftware.jeb.client.script.JythonDynamicWrapper;
import com.pnfsoftware.jeb.client.script.LogRedirectionOutputStream;
import com.pnfsoftware.jeb.core.IPlugin;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.lang.reflect.InvocationTargetException;

public class JebPythonPluginFactory {
    private static final ILogger logger = GlobalLog.getLogger(JebPythonPluginFactory.class);
    private JythonDynamicWrapper j;
    private String directory;
    private String classname;
    private Object interpreter;
    private Object pluginClass;

    public JebPythonPluginFactory(JythonDynamicWrapper jythonDynamicWrapper, String string, String string2) {
        this.j = jythonDynamicWrapper;
        this.directory = string;
        this.classname = string2;
        this.init();
    }

    private void init() {
        try {
            long l2 = System.currentTimeMillis();
            this.interpreter = this.j.PythonInterpreter_init(null, this.j.PySystemState_init());
            this.j.PythonInterpreter_exec(this.interpreter, "import sys");
            this.j.PythonInterpreter_exec(this.interpreter, String.format("sys.path.append(\"%s\")", this.directory.replace("\\", "\\\\")));
            this.j.PythonInterpreter_exec(this.interpreter, String.format("from %s import %s", this.classname, this.classname));
            LogRedirectionOutputStream logRedirectionOutputStream = new LogRedirectionOutputStream();
            this.j.PythonInterpreter_setOut(this.interpreter, logRedirectionOutputStream);
            this.pluginClass = this.j.PythonInterpreter_get(this.interpreter, this.classname);
            logger.info("%s: Python plugin loaded in %dms", this.classname, System.currentTimeMillis() - l2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getTargetException());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public void close() {
        try {
            this.j.PythonInterpreter_cleanup(this.interpreter);
            this.interpreter = null;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    public Class<? extends IPlugin> reload() {
        this.init();
        return this.getPluginClass();
    }

    public Class<? extends IPlugin> getPluginClass() {
        if (this.interpreter == null) {
            throw new IllegalStateException("The factory was closed");
        }
        try {
            Class clazz = (Class)this.j.PyObject_tojava(this.pluginClass, Class.class);
            return clazz;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getTargetException());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

