/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.installer;

import com.pnfsoftware.jeb.installer.IFileOverwriteDecider;
import com.pnfsoftware.jeb.installer.IO;
import com.pnfsoftware.jeb.installer.Logger;
import com.pnfsoftware.jeb.installer.Version;
import com.pnfsoftware.jeb.installer.ZipUnpacker;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SoftwareUpdater {
    public static final String JEB_JAR = "jeb.jar";
    public static final String UPDATE_FILENAME = "update.zip";
    public static final String UPDATE_PASS_FILENAME = "update.pwd";
    public static final String VERSION_FILENAME = "VERSION.TXT";
    public static final String VERSION_SUBPATH = "bin/VERSION.TXT";
    String basedir;
    String prgdir;
    String appdir;

    public SoftwareUpdater(String basedir, String prgdir, String appdir) {
        this.basedir = basedir;
        this.prgdir = prgdir;
        this.appdir = appdir;
    }

    public boolean start() {
        int retcode = this.unpackUpdate(true);
        if (retcode >= 0) {
            retcode = this.decryptMainJar();
        }
        return retcode >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int unpackUpdate(boolean deleteArchiveOnSuccess) {
        File file = new File(this.basedir, UPDATE_FILENAME);
        if (!file.exists()) {
            return 0;
        }
        File jebfile = new File(this.appdir, JEB_JAR);
        if (!jebfile.exists() || !jebfile.canWrite()) {
            // empty if block
        }
        int r = 0;
        ZipFile zip = null;
        try {
            zip = new ZipFile(file);
            r = this.unpackUpdatePackage(zip, this.basedir);
        }
        catch (IOException e) {
            Logger.log("Invalid update package, the decompression process will not take place", new Object[0]);
            Logger.logd(e);
            int n = 1;
            return n;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    Logger.logd(e);
                }
            }
        }
        if (r == 0 && deleteArchiveOnSuccess) {
            IO.deleteFile(file);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int unpackUpdatePackage(ZipFile zip, String basedir) {
        ZipEntry version_entry = zip.getEntry(VERSION_SUBPATH);
        if (version_entry == null) {
            Logger.log("The update package does not contain a version file", new Object[0]);
            return 1;
        }
        InputStream in = null;
        Version ver_new = null;
        try {
            in = zip.getInputStream(zip.getEntry(VERSION_SUBPATH));
            String s = new String(IO.readInputStream(in), "UTF-8");
            ver_new = Version.parseFromString(s.trim());
        }
        catch (IOException e) {
            Logger.log("Cannot read the version file", new Object[0]);
            Logger.logd(e);
            int n = 1;
            return n;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (ver_new == null) {
            Logger.log("Invalid version file", new Object[0]);
            return 1;
        }
        Version ver_old = Version.parseFromFile(new File(basedir, VERSION_SUBPATH));
        if (ver_old != null && ver_old.compareTo(ver_new) >= 0) {
            return 0;
        }
        Logger.log("A newer version of JEB was found in %s", UPDATE_FILENAME);
        ZipUnpacker unp = new ZipUnpacker(zip, basedir);
        unp.setFileOverwriteDecider(new FileOverwriteDecider());
        unp.unzip();
        List<String> errorpaths = unp.getErrorPaths();
        if (!errorpaths.isEmpty()) {
            Logger.log("Errors occurred while unzipping the following files:", new Object[0]);
            for (String path : errorpaths) {
                Logger.log("- %s\n", path);
            }
            return 1;
        }
        Logger.log("The update package was successfully decompressed", new Object[0]);
        return 0;
    }

    private int decryptMainJar() {
        byte[] key;
        Version ver = Version.parseFromFile(new File(this.basedir, VERSION_SUBPATH));
        if (ver == null) {
            return -1;
        }
        File file = new File(this.appdir, JEB_JAR);
        File encfile = new File(file.getAbsolutePath() + ".encrypted");
        if (!encfile.exists()) {
            if (file.exists()) {
                return 1;
            }
            return -1;
        }
        String password = null;
        File pwdfile = new File(this.basedir, UPDATE_PASS_FILENAME);
        if (pwdfile.exists()) {
            Logger.log("Reading password from %s", UPDATE_PASS_FILENAME);
            try {
                password = new String(IO.readFileSafe(new File(this.basedir, UPDATE_PASS_FILENAME)), "UTF8").trim();
            }
            catch (Exception e) {
                Logger.logd(e);
            }
        }
        if (password == null) {
            System.out.print("JEB decryption password: ");
            try {
                password = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset())).readLine().trim();
            }
            catch (IOException e) {
                Logger.log("Cannot read the decryption password", new Object[0]);
                Logger.logd(e);
                return -1;
            }
            if (password == null) {
                return -1;
            }
        }
        try {
            key = password.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            Logger.log("Error generating the decryption key", new Object[0]);
            Logger.logd(e1);
            return -1;
        }
        byte[] data = IO.readFileSafe(encfile);
        if (data == null || data.length < 32) {
            Logger.log("The encrypted file is invalid", new Object[0]);
            return -1;
        }
        this.rc4(key, data, 32, data.length);
        byte[] hash = this.sha256(data, 32, data.length);
        byte[] expected_hash = Arrays.copyOf(data, 32);
        if (!Arrays.equals(hash, expected_hash)) {
            Logger.log("Invalid password or the decrypted file is corrupted", new Object[0]);
            return -1;
        }
        if (!IO.writeFileSafe(file, Arrays.copyOfRange(data, 32, data.length), false)) {
            Logger.log("Error writing the decrypted file", new Object[0]);
            return -1;
        }
        if (!IO.deleteFile(encfile)) {
            Logger.log("Cannot delete the encrypted file, please delete %s manually", encfile.getAbsoluteFile());
            return 1;
        }
        IO.deleteFile(pwdfile);
        Logger.log("The protected JEB file was successfully decrypted", new Object[0]);
        return 0;
    }

    private void rc4(byte[] key, byte[] data, int data_start, int data_end) {
        int i;
        int keylen = key.length;
        if (keylen == 0) {
            return;
        }
        byte[] sbox = new byte[256];
        for (i = 0; i < 256; ++i) {
            sbox[i] = (byte)i;
        }
        int j = 0;
        for (i = 0; i < 256; ++i) {
            j = (j + sbox[i] + key[i % keylen]) % 256 & 0xFF;
            byte tmp = sbox[i];
            sbox[i] = sbox[j];
            sbox[j] = tmp;
        }
        i = 0;
        j = 0;
        int index = data_start;
        while (index < data_end) {
            i = (i + 1) % 256 & 0xFF;
            j = (j + sbox[i]) % 256 & 0xFF;
            byte tmp = sbox[i];
            sbox[i] = sbox[j];
            sbox[j] = tmp;
            byte k = sbox[(sbox[i] + sbox[j]) % 256 & 0xFF];
            int n = index++;
            data[n] = (byte)(data[n] ^ k);
        }
    }

    private byte[] sha256(byte[] data, int data_start, int data_end) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(data, data_start, data_end - data_start);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static class FileOverwriteDecider
    implements IFileOverwriteDecider {
        static String JVM_OPTIONS_FILENAME = "jvmopt.txt";
        static String JVM_OPTIONS_DEFAULT_CONTENTS = "-Xss4M -Xmx8G";

        private FileOverwriteDecider() {
        }

        @Override
        public boolean isOverwriteAllowed(File currentFile, String entryName, byte[] newData) {
            if (JVM_OPTIONS_FILENAME.equals(entryName)) {
                try {
                    String text = new String(IO.readFile(currentFile), Charset.defaultCharset()).trim();
                    if (text.equals(JVM_OPTIONS_DEFAULT_CONTENTS)) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Logger.logd("Will not overwrite custom file: %s", entryName);
                return false;
            }
            return true;
        }
    }
}

