/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.androidjnihelper;

import com.pnf.plugin.androidjnihelper.JNINativeMethod;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.android.IApkUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ISymbolInformation;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class JNIReport {
    private Map<String, ApkData> report = new HashMap<String, ApkData>();

    private ApkData getApkData(IApkUnit apk) {
        ApkData data = this.report.get(apk.getName());
        if (data == null) {
            data = new ApkData();
            this.report.put(apk.getName(), data);
        }
        return data;
    }

    public void saveDynamicMethodMatch(IApkUnit apk, IUnit elf, String signature, String libName, JNINativeMethod jni, String oldMethodName, String methodName) {
        List<ApkBinding> lines = this.getApkData(apk).getBindings(signature);
        lines.add(new ApkBinding(true, libName, elf.getName(), jni.fnPtr, oldMethodName, methodName));
    }

    public void saveStaticMethod(IApkUnit apk, IUnit elf, String signature, String libName, ISymbolInformation sym) {
        List<ApkBinding> lines = this.getApkData(apk).getBindings(signature);
        lines.add(new ApkBinding(false, libName, elf.getName(), sym.getRelativeAddress(), sym.getName(), null));
    }

    public void saveMissingMethod(IApkUnit apk, String signature, String libName) {
        List<ApkBinding> lines = this.getApkData(apk).getBindings(signature);
        lines.add(new ApkBinding(true, libName, null, 0L, null, null));
    }

    public String getReport() {
        StringBuilder stb = new StringBuilder();
        stb.append("JNI Method summary\n");
        stb.append("------------------\n");
        if (this.report.isEmpty()) {
            stb.append("No JNI Method found!");
            return stb.toString();
        }
        int totalNativeMethods = 0;
        HashMap<String, Integer> dynamicNativeMethodsPerLib = new HashMap<String, Integer>();
        HashMap staticNativeMethodsPerLib = new HashMap();
        for (Map.Entry<String, ApkData> reportEntry : this.report.entrySet()) {
            stb.append(reportEntry.getKey()).append('\n');
            int maxLength = 20;
            for (Map.Entry<String, List<ApkBinding>> apkBindings : reportEntry.getValue().bindings.entrySet()) {
                if (apkBindings.getKey().length() <= maxLength || (maxLength = apkBindings.getKey().length()) <= 90) continue;
                maxLength = 90;
                break;
            }
            for (Map.Entry<String, List<ApkBinding>> apkBindings : reportEntry.getValue().bindings.entrySet()) {
                ++totalNativeMethods;
                if (this.isBindingFound(apkBindings.getValue())) {
                    for (ApkBinding line : apkBindings.getValue()) {
                        int pad = maxLength - apkBindings.getKey().length();
                        stb.append(apkBindings.getKey()).append(Strings.pad((char)' ', (int)(pad >= 0 ? pad : Math.abs(pad) % 10))).append(" --> ").append(line).append('\n');
                        this.increment(line.dynamic ? dynamicNativeMethodsPerLib : staticNativeMethodsPerLib, line.libName);
                    }
                    continue;
                }
                stb.append("No binding found for ").append(apkBindings.getKey()).append('\n');
            }
        }
        stb.append("------------------\n");
        stb.append("Found a total of ").append(totalNativeMethods).append(" native methods.\n");
        HashSet libs = new HashSet();
        libs.addAll(dynamicNativeMethodsPerLib.keySet());
        libs.addAll(staticNativeMethodsPerLib.keySet());
        for (String lib : libs) {
            stb.append("Found ").append(dynamicNativeMethodsPerLib.get(lib)).append(" dynamic method(s) and ").append(staticNativeMethodsPerLib.get(lib)).append(" static method(s) for ").append(lib).append(".\n");
        }
        stb.append("------------------\n");
        return stb.toString();
    }

    private void increment(Map<String, Integer> map, String libName) {
        Integer res = map.get(libName);
        res = res == null ? Integer.valueOf(1) : Integer.valueOf(res + 1);
        map.put(libName, res);
    }

    private boolean isBindingFound(List<ApkBinding> bs) {
        for (ApkBinding b : bs) {
            if (!b.isBindingFound()) continue;
            return true;
        }
        return false;
    }

    private static class ApkBinding {
        private boolean dynamic;
        private String libName;
        private String elfName;
        private long nativePtr;
        private String oldMethodName;
        private String methodName;

        public ApkBinding(boolean dynamic, String libName, String elfName, long nativePtr, String oldMethodName, String methodName) {
            this.dynamic = dynamic;
            this.libName = libName;
            this.elfName = elfName;
            this.nativePtr = nativePtr;
            this.oldMethodName = oldMethodName;
            this.methodName = methodName;
        }

        public boolean isBindingFound() {
            return this.elfName != null;
        }

        public String toString() {
            if (!this.isBindingFound()) {
                return this.libName + ": Can not fount JNI Endpoint";
            }
            return (this.dynamic ? "Dynamic" : "Static") + " JNI detected in " + this.libName + "/" + this.elfName + " @" + Long.toHexString(this.nativePtr) + "h. Method " + (this.methodName != null ? "was renamed from " + this.oldMethodName + " to " + this.methodName : "name is " + this.oldMethodName);
        }
    }

    private static class ApkData {
        Map<String, List<ApkBinding>> bindings = new TreeMap<String, List<ApkBinding>>();

        private ApkData() {
        }

        public List<ApkBinding> getBindings(String signature) {
            List<ApkBinding> lines = this.bindings.get(signature);
            if (lines == null) {
                lines = new ArrayList<ApkBinding>();
                this.bindings.put(signature, lines);
            }
            return lines;
        }
    }
}

