/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.androidjnihelper;

import com.pnf.plugin.androidjnihelper.IDynamicJNIDetectionHeuritic;
import com.pnf.plugin.androidjnihelper.JNINativeMethod;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.EntryPointDescription;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.IEntryPointDescription;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEConverter;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEState;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IdRanges;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.codeobject.ISymbolInformation;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class DynamicJNIDetectionHeurRegisterNatives
implements IDynamicJNIDetectionHeuritic {
    private static final ILogger logger = GlobalLog.getLogger(DynamicJNIDetectionHeurRegisterNatives.class);

    @Override
    public List<JNINativeMethod> determine(INativeCodeUnit<?> codeUnit, List<IDexMethod> nativeMethods, ISymbolInformation onload) {
        ArrayList<JNINativeMethod> registered = new ArrayList<JNINativeMethod>();
        EntryPointDescription ep = codeUnit.getProcessor().createEntryPoint(codeUnit.getVirtualImageBase() + onload.getSymbolRelativeAddress());
        INativeMethodItem method = codeUnit.getInternalMethod(ep.getAddress(), true);
        if (method == null && (method = codeUnit.getMethod("JNI_OnLoad")) == null) {
            return registered;
        }
        for (BasicBlock block : method.getData().getCFG().getBlocks()) {
            long ptrMethods0;
            int nMethods;
            IDecompilerUnit decompiler;
            if (!this.isBlockCallsRegisterNatives(codeUnit, block) || (decompiler = DecompilerHelper.getDecompiler(codeUnit)) == null || !(decompiler instanceof INativeDecompilerUnit)) continue;
            IEConverter conv = ((INativeDecompilerUnit)decompiler).getConverter();
            IERoutineContext ctx = null;
            List r = null;
            try {
                ctx = conv.convert(method);
                BasicBlock bb = ctx.getCfg().getBlockAt(ctx.convertNativeAddress(block.getFirstAddress()).longValue());
                r = bb.getInstructions();
            }
            catch (Exception e) {
                logger.catching((Throwable)e);
            }
            if (ctx == null || r == null) {
                return registered;
            }
            IEGeneric[] targets = new IEGeneric[]{conv.getRegisterVariableFromNativeRegisterId(2L), conv.getRegisterVariableFromNativeRegisterId(3L)};
            if (!EUtil.resolveExpressionsBackward((Object)"RegisterNatives", (IEConverter)conv, (List)r, (IEGeneric[])targets) || DynamicJNIDetectionHeurRegisterNatives.hasVariable(targets[0]) || DynamicJNIDetectionHeurRegisterNatives.hasVariable(targets[1])) continue;
            IEState state = ctx.getGlobalContext().buildState();
            IVirtualMemory vm = codeUnit.getMemory();
            state.setMemory(vm);
            try {
                nMethods = (int)targets[1].evaluateUnsignedLong(state);
                logger.info("Number of methods: %d", new Object[]{nMethods});
                ptrMethods0 = (int)targets[0].evaluateUnsignedLong(state);
                logger.info("Pointer to methods: %xh", new Object[]{ptrMethods0});
            }
            catch (Exception e) {
                logger.error("Can not determine parameters of RegisterNatives method in block @%xh", new Object[]{block.getFirstAddress()});
                continue;
            }
            AtomicLong ptrMethods = new AtomicLong(ptrMethods0);
            for (int j = 0; j < nMethods; ++j) {
                JNINativeMethod jni = JNINativeMethod.buildJNIFromMemPointer(codeUnit, vm, ptrMethods);
                if (jni == null) continue;
                registered.add(jni);
            }
        }
        return registered;
    }

    private boolean isBlockCallsRegisterNatives(INativeCodeUnit<?> codeUnit, BasicBlock<?> block) {
        long targetAddress;
        String label;
        IFlowInformation flow;
        List instructions = block.getInstructions();
        long address = block.getAddressOfInstruction(instructions.size() - 1);
        IInstruction insn = (IInstruction)instructions.get(instructions.size() - 1);
        if (insn.getMnemonic().startsWith("BL") && (flow = insn.getRoutineCall(address)).isBrokenKnown() && flow.getTargets().size() == 1 && (label = codeUnit.getAddressLabel(Formatter.toHexString((long)(targetAddress = ((IEntryPointDescription)flow.getTargets().get(0)).getAddress()), (boolean)false) + "h")) != null && label.contains("RegisterNatives")) {
            logger.debug("Found potential RegisterNatives call @%xh", new Object[]{address});
            return true;
        }
        return false;
    }

    private static boolean hasVariable(IEGeneric ire) {
        IdRanges use = new IdRanges();
        ire.getUsed(use);
        return !use.getVarIds().isEmpty();
    }
}

