/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.model;

import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MethodSignature {
    private String cname;
    private String mname;
    private String shorty;
    private String prototype;
    private String versions;
    private String[] versionsCache;
    private List<MethodSignatureRevision> revisions = new ArrayList<MethodSignatureRevision>();

    public String getCname() {
        return this.cname;
    }

    public String getMname() {
        return this.mname;
    }

    public String getShorty() {
        return this.shorty;
    }

    public String getPrototype() {
        return this.prototype;
    }

    public boolean isEmptyOp() {
        if (this.revisions.size() == 0) {
            return false;
        }
        for (MethodSignatureRevision rev : this.revisions) {
            if (rev.opcount == 0) continue;
            return false;
        }
        return true;
    }

    public List<MethodSignatureRevision> getRevisions() {
        return this.revisions;
    }

    public boolean hasCaller() {
        if (this.revisions.size() == 0) {
            return false;
        }
        if (this.revisions.size() != 1) {
            for (MethodSignatureRevision rev : this.revisions) {
                if (Strings.isBlank((String)rev.caller)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public Map<String, Integer> getTargetCaller() {
        return MethodSignature.getTargetCaller(this.revisions.get(0).caller);
    }

    private String getParentField() {
        if (this.revisions.size() == 0) {
            return null;
        }
        String superT = this.revisions.get(0).caller;
        if (this.revisions.size() != 1) {
            for (MethodSignatureRevision rev : this.revisions) {
                if (rev.caller.equals(superT)) continue;
                return null;
            }
        }
        if (superT.isEmpty()) {
            return null;
        }
        return superT;
    }

    public String getTargetSuperType() {
        return MethodSignature.getTargetSuperType(this.getParentField());
    }

    private static String getTargetSuperType(String superT) {
        if (superT == null) {
            return null;
        }
        String[] parents = superT.split("\\|\\|");
        if (parents.length == 0 || parents[0].isEmpty()) {
            return null;
        }
        List<String> parent = MethodSignature.getParentClasses(parents[0]);
        if (parent == null || parent.size() != 1) {
            return null;
        }
        return parent.get(0);
    }

    public List<String> getTargetInterfaces() {
        return MethodSignature.getTargetInterfaces(this.getParentField());
    }

    private static List<String> getTargetInterfaces(String superT) {
        if (superT == null) {
            return null;
        }
        String[] parents = superT.split("\\|\\|");
        if (parents.length != 2) {
            return null;
        }
        return MethodSignature.getParentClasses(parents[1]);
    }

    private static List<String> getParentClasses(String parent) {
        ArrayList<String> targetCallerList = new ArrayList<String>();
        if (parent.isEmpty()) {
            return targetCallerList;
        }
        String[] targetCallers = parent.split("\\|");
        targetCallerList.addAll(Arrays.asList(targetCallers));
        return targetCallerList;
    }

    public static Map<String, Integer> getTargetCaller(String caller) {
        HashMap<String, Integer> targetCallerList = new HashMap<String, Integer>();
        if (caller.isEmpty()) {
            return targetCallerList;
        }
        String[] targetCallers = caller.split("\\|");
        for (int i = 0; i < targetCallers.length; ++i) {
            String[] tokens = targetCallers[i].split("=");
            targetCallerList.put(tokens[0], Integer.parseInt(tokens[1]));
        }
        return targetCallerList;
    }

    public String[] getVersions() {
        if (this.versions == null || this.versions.isEmpty()) {
            return null;
        }
        if (this.versionsCache == null) {
            this.versionsCache = this.versions.split(";");
        }
        return this.versionsCache;
    }

    public MethodSignature() {
    }

    public MethodSignature(String cname, String mname, String shorty, String prototype, String versions) {
        this.cname = cname;
        this.mname = mname;
        this.shorty = shorty;
        this.prototype = prototype;
        this.versions = versions;
    }

    public static MethodSignature parse(String line) {
        return MethodSignature.parse(line, true);
    }

    public static MethodSignature parse(String line, boolean strict) {
        String[] tokens = line.trim().split(",");
        if (tokens.length < 8) {
            return null;
        }
        MethodSignature ml = new MethodSignature();
        ml.cname = tokens[0];
        if (!ml.cname.startsWith("L") || !ml.cname.endsWith(";")) {
            return null;
        }
        ml.mname = tokens[1];
        if (ml.mname.isEmpty()) {
            return null;
        }
        ml.shorty = tokens[2];
        if (strict && ml.shorty.isEmpty()) {
            return null;
        }
        ml.prototype = tokens[3];
        if (strict && ml.prototype.isEmpty()) {
            return null;
        }
        ml.addRevision(MethodSignature.buildRevision(tokens));
        if (tokens.length > 8) {
            ml.versions = tokens[8];
        }
        return ml;
    }

    public MethodSignatureRevision getOwnRevision() {
        return this.revisions.get(0);
    }

    private static MethodSignatureRevision buildRevision(String[] tokens) {
        MethodSignatureRevision revision = new MethodSignatureRevision();
        revision.opcount = Conversion.stringToInt((String)tokens[4]);
        if (revision.opcount < 0) {
            return null;
        }
        revision.mhash_tight = tokens[5].equals("null") ? "" : tokens[5];
        revision.mhash_loose = tokens[6].equals("null") ? "" : tokens[6];
        revision.caller = tokens[7].equals("null") ? "" : tokens[7];
        if (tokens.length > 8) {
            revision.versions = tokens[8];
        }
        return revision;
    }

    public void addRevision(MethodSignatureRevision revision) {
        if (this.revisions.contains(revision)) {
            return;
        }
        this.revisions.add(revision);
        this.versions = this.versions == null ? revision.versions : this.versions + ";" + revision.versions;
        this.versionsCache = null;
    }

    public String toString() {
        return String.format("%s,%s,%s,%s", this.cname, this.mname, this.shorty, this.prototype);
    }

    public static boolean isSignatureLine(String line) {
        return !line.isEmpty() && !line.startsWith(";");
    }

    public static String[] parseNative(String line) {
        String[] tokens = line.trim().split(",");
        if (tokens.length < 8) {
            return null;
        }
        return tokens;
    }

    public static String[] parseNative(byte[] data, int startIndex, int endIndex) {
        String[] tokens = new String[9];
        int index = 0;
        int iStart = startIndex;
        for (int i = startIndex; i < endIndex; ++i) {
            if (data[i] != 44) continue;
            if (index == 0 || index == 1 || index == 5 || index == 6) {
                tokens[index] = new String(data, iStart, i - iStart);
            }
            ++index;
            iStart = i + 1;
        }
        if (++index < 8) {
            return null;
        }
        return tokens;
    }

    public static String getTightSignature(String[] signatureLine) {
        return signatureLine[5];
    }

    public static String getLooseSignature(String[] signatureLine) {
        return signatureLine[6];
    }

    public static String getShorty(String[] signatureLine) {
        return signatureLine[2];
    }

    public static String getPrototype(String[] signatureLine) {
        return signatureLine[3];
    }

    public static String getClassname(String[] signatureLine) {
        return signatureLine[0];
    }

    public static String getMethodName(String[] signatureLine) {
        return signatureLine[1];
    }

    public static String[] getVersions(String[] signatureLine) {
        if (signatureLine.length <= 8 || signatureLine[8] == null) {
            return null;
        }
        return signatureLine[8].split(";");
    }

    public String[] toTokens() {
        return new String[]{this.cname, this.mname, this.shorty, this.prototype};
    }

    public static boolean equalsClassMethodSig(MethodSignature ref, MethodSignature current) {
        return ref.getCname().equals(current.getCname()) && ref.getMname().equals(current.getMname()) && ref.getPrototype().equals(current.getPrototype());
    }

    public static boolean equalsMethodSig(MethodSignature ref, MethodSignature current) {
        return ref.getMname().equals(current.getMname()) && ref.getPrototype().equals(current.getPrototype());
    }

    public static MethodSignature mergeSignatures(List<MethodSignature> results, boolean mergeVersions, IDexMethod eMethod) {
        if (results == null || results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        String mname = eMethod.getName(true);
        List res2 = results.stream().filter(s -> s.getMname().equals(mname)).collect(Collectors.toList());
        if (!res2.isEmpty() && (results = res2).size() == 1) {
            return results.get(0);
        }
        String[] result = new String[5];
        block0: for (int i = 0; i < 5; ++i) {
            for (MethodSignature ress : results) {
                String[] res = ress.toTokens();
                if (i >= res.length) continue;
                if (result[i] == null) {
                    result[i] = res[i];
                    continue;
                }
                if (result[i].equals(res[i])) continue;
                result[i] = "";
                if (i == 1) continue block0;
            }
        }
        String versionsStr = null;
        if (mergeVersions) {
            HashSet<String> versions = new HashSet<String>();
            for (MethodSignature value : results) {
                String[] vArray = value.getVersions();
                if (vArray == null) continue;
                for (String version : vArray) {
                    versions.add(version);
                }
            }
            versionsStr = Strings.join((String)";", versions);
        }
        return new MethodSignature(MethodSignature.getClassname(result), MethodSignature.getMethodName(result), MethodSignature.getShorty(result), MethodSignature.getPrototype(result), versionsStr);
    }

    public static class MethodSignatureRevision {
        private int opcount;
        private String mhash_tight;
        private String mhash_loose;
        private String caller;
        private String versions;

        public String getMhash_tight() {
            return this.mhash_tight;
        }

        public String getMhash_loose() {
            return this.mhash_loose;
        }

        public int getOpcount() {
            return this.opcount;
        }

        public String getCaller() {
            return this.caller;
        }

        public String[] getVersions() {
            if (this.versions == null || this.versions.isEmpty()) {
                return null;
            }
            return this.versions.split(";");
        }

        public String getTargetSuperType() {
            return MethodSignature.getTargetSuperType(this.caller);
        }

        public List<String> getTargetInterfaces() {
            return MethodSignature.getTargetInterfaces(this.caller);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.caller == null ? 0 : this.caller.hashCode());
            result = 31 * result + (this.mhash_loose == null ? 0 : this.mhash_loose.hashCode());
            result = 31 * result + (this.mhash_tight == null ? 0 : this.mhash_tight.hashCode());
            result = 31 * result + this.opcount;
            result = 31 * result + (this.versions == null ? 0 : this.versions.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodSignatureRevision other = (MethodSignatureRevision)obj;
            if (this.caller == null ? other.caller != null : !this.caller.equals(other.caller)) {
                return false;
            }
            if (this.mhash_loose == null ? other.mhash_loose != null : !this.mhash_loose.equals(other.mhash_loose)) {
                return false;
            }
            if (this.mhash_tight == null ? other.mhash_tight != null : !this.mhash_tight.equals(other.mhash_tight)) {
                return false;
            }
            if (this.opcount != other.opcount) {
                return false;
            }
            return !(this.versions == null ? other.versions != null : !this.versions.equals(other.versions));
        }
    }
}

