/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.installer;

import com.pnfsoftware.jeb.installer.IO;
import com.pnfsoftware.jeb.installer.Logger;
import com.pnfsoftware.jeb.installer.OSType;
import com.pnfsoftware.jeb.installer.ZipUnpacker;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;

public class LibraryInstaller {
    String basedir;
    String prgdir;
    String appdir;
    OSType ostype;

    public LibraryInstaller(String basedir, String prgdir, String appdir) {
        this.basedir = basedir;
        this.prgdir = prgdir;
        this.appdir = appdir;
        this.ostype = OSType.determine();
        if (!this.ostype.isKnown()) {
            throw new RuntimeException("Unsupported operating system");
        }
        if (!this.ostype.is64bit()) {
            throw new RuntimeException("Detected " + (Object)((Object)this.ostype) + " - Support for non 64-bit environments was dropped with JEB3!");
        }
    }

    public boolean start() {
        boolean success = true;
        int retcode = this.dropPlatformSpecificComponent(this.appdir, ".swt", "swt.jar", false);
        if (retcode != 0) {
            Logger.log("Cannot install UI library (error code: %d)", retcode);
            success = false;
        }
        if ((retcode = this.dropPlatformSpecificComponent(this.prgdir, ".launchers", "launcher.zip", true)) < 0) {
            Logger.log("Cannot install launcher (error code: %d)", retcode);
            success = false;
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int dropPlatformSpecificComponent(String base, String foldername, String filename, boolean unzip) {
        long size1;
        File file0 = new File(base, foldername + "/" + this.ostype.getFolderName() + "/" + filename);
        if (!file0.exists()) {
            Logger.log("File not found: %s", file0);
            return 1;
        }
        long size0 = file0.length();
        File file1 = new File(base, filename);
        if (file1.exists() && size0 == (size1 = file1.length())) {
            return 0;
        }
        try {
            IO.copyFile(file0, file1, true);
        }
        catch (IOException e) {
            Logger.log("Failed to copy file %s to %s", file0, file1);
            Logger.logd(e);
            return -1;
        }
        if (!unzip) return 0;
        try (ZipFile zip = new ZipFile(file1);){
            if (new ZipUnpacker(zip, base).unzip()) return 0;
            int n = -2;
            return n;
        }
        catch (IOException e) {
            Logger.log("Exception when unzipping file %s", file1, e);
            Logger.logd(e);
            return -3;
        }
    }
}

