/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.code.CodeDocumentPart;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.IInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IInstructionOperandSized;
import com.pnfsoftware.jeb.core.units.code.asm.render.GenericCodeFormatter;
import com.pnfsoftware.jeb.core.units.code.asm.render.NumberFormatter;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jebglobal.CN;
import com.pnfsoftware.jebglobal.HH;
import com.pnfsoftware.jebglobal.aV;
import com.pnfsoftware.jebglobal.fl;
import com.pnfsoftware.jebglobal.xZ;

@Ser
public class OA
extends GenericCodeFormatter<xZ> {
    @Override
    public String getMemoryAccessSizeInfo(IInstruction iInstruction, IInstructionOperandSized iInstructionOperandSized) {
        int n = iInstructionOperandSized.getOperandBitsize();
        switch (n) {
            case 0: {
                return "";
            }
            case 8: {
                return "byte ptr ";
            }
            case 16: {
                return "word ptr ";
            }
            case 32: {
                return "dword ptr ";
            }
            case 48: {
                return "fword ptr ";
            }
            case 64: {
                return "qword ptr ";
            }
            case 80: {
                return "tword ptr ";
            }
            case 128: {
                return "dqword ptr ";
            }
            case 256: {
                return "qqword ptr ";
            }
        }
        return String.format("%db ptr ", n);
    }

    @Override
    public String getMemoryAccessSegmentInfo(IInstruction iInstruction, IInstructionOperand iInstructionOperand) {
        xZ xZ2 = (xZ)iInstruction;
        aV aV2 = (aV)iInstructionOperand;
        long l2 = fl.eO(xZ2, aV2);
        if (l2 == 0L) {
            return "";
        }
        return this.getRegisterName(l2) + ":";
    }

    @Override
    public String getRegisterName(long l2) {
        try {
            return fl.lS(l2);
        }
        catch (RuntimeException runtimeException) {
            return "unkreg_" + l2;
        }
    }

    @Override
    public void formatOperand(long l2, IInstruction iInstruction, IInstructionOperand iInstructionOperand, int n, int n2, CodeDocumentPart codeDocumentPart) {
        if (iInstructionOperand instanceof aV) {
            aV aV2 = (aV)iInstructionOperand;
            switch (aV2.getOperandType()) {
                case 4097: {
                    this.eO(l2, iInstruction, (HH)iInstructionOperand, n, codeDocumentPart);
                    return;
                }
                case 8: {
                    this.eO(l2, iInstruction, (CN)iInstructionOperand, n, codeDocumentPart);
                    return;
                }
            }
        }
        super.formatOperand(l2, iInstruction, iInstructionOperand, n, n2, codeDocumentPart);
    }

    private void eO(long l2, IInstruction iInstruction, HH hH, int n, CodeDocumentPart codeDocumentPart) {
        int n2 = hH.Le();
        long l3 = (long)hH.Qx() & 0xFFFFFFFFL;
        String string = String.format("%Xh:%Xh", n2, l3);
        codeDocumentPart.append(string);
    }

    private void eO(long l2, IInstruction iInstruction, CN cN2, int n, CodeDocumentPart codeDocumentPart) {
        codeDocumentPart.append(this.getMemoryAccessSizeInfo(iInstruction, cN2));
        codeDocumentPart.append(this.getMemoryAccessSegmentInfo(iInstruction, cN2));
        codeDocumentPart.append(this.getMemoryAccessPrefix());
        long l3 = cN2.getMemoryBaseRegister();
        long l4 = cN2.getMemoryIndexRegister();
        long l5 = cN2.getMemoryDisplacement();
        if (l2 != 0L && l4 < 0L && l3 >= 0L && fl.eO(l3) == 10) {
            long l6 = l5;
            int n2 = fl.Le(l3);
            if (n2 == 32) {
                l6 = l6 + l2 + (long)iInstruction.getSize() & 0xFFFFFFFFL;
            } else if (n2 == 64) {
                l6 = l6 + l2 + (long)iInstruction.getSize();
            }
            this.formatAddress(l6, codeDocumentPart);
        } else {
            if (l3 >= 0L) {
                this.formatRegister(l3, codeDocumentPart);
            }
            if (l4 >= 0L) {
                int n3;
                if (l3 >= 0L) {
                    codeDocumentPart.append("+");
                }
                if ((n3 = cN2.getMemoryScale()) >= 2) {
                    codeDocumentPart.append(n3 + "*");
                }
                this.formatRegister(l4, codeDocumentPart);
            }
            if (l5 != 0L) {
                if (l3 >= 0L || l4 >= 0L) {
                    if (l5 < 0L) {
                        l5 = -l5;
                        codeDocumentPart.append("-");
                    } else {
                        codeDocumentPart.append("+");
                    }
                }
                if (this.getCodeUnit().getCodeAnalyzer().getAnalysisRanges().contains(l5) && this.getCodeUnit().getNativeItemAt(l5) != null) {
                    this.formatAddress(l5, codeDocumentPart);
                } else {
                    String string = this.getDefaultNumberFormatter().format(64, l5, NumberFormatter.NumberBase.HEXADECIMAL, false);
                    codeDocumentPart.appendAndRecord(string, ItemClassIdentifiers.IMMEDIATE);
                }
            } else if (l3 < 0L && l4 < 0L) {
                codeDocumentPart.appendAndRecord("0", ItemClassIdentifiers.IMMEDIATE);
            }
        }
        codeDocumentPart.append(this.getMemoryAccessSuffix());
    }
}

