/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.google.common.collect.MapMaker;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICElement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.math.MathUtil;
import com.pnfsoftware.jeb.util.primitives.LargeIntHandler;
import com.pnfsoftware.jeb.util.primitives.Longs;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jebglobal.EH;
import com.pnfsoftware.jebglobal.GU;
import com.pnfsoftware.jebglobal.PV;
import com.pnfsoftware.jebglobal.Zp;
import com.pnfsoftware.jebglobal.jB;
import java.math.BigInteger;
import java.util.Map;

@Ser
public class BP
extends jB {
    private static Map<Couple<Long, Integer>, BP> ae = new MapMaker().weakValues().makeMap();
    @SerId(value=1)
    protected long lS;

    public static BP Le(long l2, int n) {
        if (n > 64) {
            throw new IllegalArgumentException("Illegal bitsize, greater than 64: " + n);
        }
        long l3 = MathUtil.signExtend(l2, n);
        Couple<Long, Integer> couple = new Couple<Long, Integer>(l3, n);
        BP bP = ae.get(couple);
        if (bP == null) {
            bP = new BP(l3, n);
            ae.put(couple, bP);
        }
        return bP;
    }

    private BP(long l2, int n) {
        super(n);
        this.lS = l2;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (int)(this.lS ^ this.lS >>> 32);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        return this.equalsEx(object, true);
    }

    @Override
    public boolean equalsEx(Object object, boolean bl2) {
        if (this == object) {
            return true;
        }
        if (!super.equalsEx(object, bl2)) {
            return false;
        }
        if (object instanceof BP) {
            BP bP = (BP)object;
            return this.lS == bP.lS;
        }
        if (object instanceof GU) {
            GU gU2 = (GU)object;
            return this.lS == gU2.lS.longValue();
        }
        return true;
    }

    @Override
    protected jB ae() {
        BP bP = new BP(this.lS, this.eO);
        return super.eO(bP);
    }

    public Long XV() {
        return this.lS;
    }

    @Override
    protected GU TI() {
        return GU.Le(BigInteger.valueOf(this.lS), this.eO);
    }

    @Override
    public boolean canReadAsLong() {
        return true;
    }

    @Override
    public long getValueAsLong() {
        return this.lS;
    }

    @Override
    public boolean canReadAsUnsignedLong() {
        return this.eO <= 63 || this._signum() >= 0;
    }

    @Override
    public long getValueAsUnsignedLong() {
        if (!this.canReadAsUnsignedLong()) {
            throw new IllegalStateException("Cannot return value as a 64-bit unsigned long");
        }
        return MathUtil.zeroExtend(this.lS, this.eO);
    }

    @Override
    public BigInteger getValue() {
        return BigInteger.valueOf(this.lS);
    }

    @Override
    public BigInteger getUnsignedValue() {
        return new BigInteger(Longs.toUnsignedString(this.lS));
    }

    @Override
    public jB lS(int n) {
        if (n > 64) {
            return GU.eO(this.lS, n);
        }
        return BP.Le(this.lS, n);
    }

    @Override
    public jB ae(int n) {
        if (n > 64) {
            String string = Longs.toUnsignedString(this.lS);
            return GU.Le(string, n);
        }
        return BP.Le(MathUtil.zeroExtend(this.lS, this.eO), n);
    }

    @Override
    public void eO(PV pV) {
        String string;
        if (pV.Le) {
            pV.eO('i').eO(this.eO).eO(":");
        }
        switch (this.eO) {
            case 1: {
                string = Long.toString(this.lS & 1L);
                break;
            }
            case 2: {
                string = Long.toString(this.lS & 3L);
                break;
            }
            case 8: {
                string = String.format("%02Xh", this.lS & 0xFFL);
                break;
            }
            case 16: {
                string = String.format("%04Xh", this.lS & 0xFFFFL);
                break;
            }
            case 32: {
                string = String.format("%08Xh", this.lS & 0xFFFFFFFFL);
                break;
            }
            case 64: {
                string = String.format("%016Xh", this.lS);
                break;
            }
            default: {
                string = String.format("%Xh", MathUtil.zeroExtend(this.lS, this.eO));
            }
        }
        pV.eO(string);
        if (this.Le) {
            pV.Le(this);
        }
    }

    @Override
    public int _signum() {
        return this.lS > 0L ? 1 : (this.lS < 0L ? -1 : 0);
    }

    @Override
    public jB KQ() {
        if (this.lS == 0L) {
            return this;
        }
        return BP.Le(-this.lS, this.eO);
    }

    private BP qo(IEImm iEImm) {
        BP bP;
        if (iEImm.getBitsize() != this.eO) {
            throw new RuntimeException("Mismatched bit sizes between " + this + " and " + iEImm);
        }
        if (iEImm instanceof BP) {
            bP = (BP)iEImm;
        } else if (iEImm instanceof GU) {
            bP = BP.Le(iEImm.getValueAsLong(), ((GU)iEImm).eO);
        } else {
            throw new RuntimeException();
        }
        return bP;
    }

    @Override
    public jB eO(IEImm iEImm) {
        BP bP = this.qo(iEImm);
        return BP.Le(this.lS + bP.lS, this.eO);
    }

    @Override
    public jB Le(IEImm iEImm) {
        BP bP = this.qo(iEImm);
        return BP.Le(this.lS - bP.lS, this.eO);
    }

    @Override
    public jB Qx(IEImm iEImm) {
        BP bP = this.qo(iEImm);
        return BP.Le(this.lS * bP.lS, this.eO);
    }

    @Override
    public jB lS(IEImm iEImm) {
        BP bP = this.qo(iEImm);
        long l2 = this.eO == 64 ? this.lS : MathUtil.zeroExtend(this.lS, this.eO);
        long l3 = bP.eO == 64 ? bP.lS : MathUtil.zeroExtend(bP.lS, this.eO);
        return BP.Le(l2 * l3, this.eO);
    }

    @Override
    public jB ae(IEImm iEImm) {
        BP bP = this.qo(iEImm);
        return BP.Le(this.lS / bP.lS, this.eO);
    }

    @Override
    public jB TI(IEImm iEImm) {
        BP bP = this.qo(iEImm);
        long l2 = 0L;
        if (this.eO == 64 && (this.lS < 0L || bP.lS < 0L)) {
            LargeIntHandler largeIntHandler = LargeIntHandler.create(this.eO);
            l2 = largeIntHandler.divU(BigInteger.valueOf(this.lS), BigInteger.valueOf(bP.lS)).longValue();
        } else {
            long l3 = MathUtil.zeroExtend(this.lS, this.eO);
            long l4 = MathUtil.zeroExtend(bP.lS, this.eO);
            l2 = l3 / l4;
        }
        return BP.Le(l2, this.eO);
    }

    @Override
    public jB vT(IEImm iEImm) {
        BP bP = this.qo(iEImm);
        return BP.Le(this.lS % bP.lS, this.eO);
    }

    @Override
    public jB KQ(IEImm iEImm) {
        BP bP = this.qo(iEImm);
        long l2 = this.eO == 64 ? this.lS : MathUtil.zeroExtend(this.lS, this.eO);
        long l3 = bP.eO == 64 ? bP.lS : MathUtil.zeroExtend(bP.lS, this.eO);
        return BP.Le(l2 % l3, this.eO);
    }

    @Override
    public jB LZ() {
        return BP.Le(this.lS ^ 0xFFFFFFFFFFFFFFFFL, this.eO);
    }

    @Override
    public jB LZ(IEImm iEImm) {
        BP bP = this.qo(iEImm);
        return BP.Le(this.lS & bP.lS, this.eO);
    }

    @Override
    public jB XV(IEImm iEImm) {
        BP bP = this.qo(iEImm);
        return BP.Le(this.lS | bP.lS, this.eO);
    }

    @Override
    public jB lo(IEImm iEImm) {
        BP bP = this.qo(iEImm);
        return BP.Le(this.lS ^ bP.lS, this.eO);
    }

    @Override
    public boolean _testbit(int n) {
        if (n < 0 || n >= this.eO) {
            throw new ArithmeticException("Invalid bit position");
        }
        return (this.lS & 1L << n) != 0L;
    }

    @Override
    public jB TI(int n) {
        if (n < 0 || n >= this.eO) {
            throw new ArithmeticException("Invalid bit position");
        }
        return BP.Le(this.lS | 1L << n, this.eO);
    }

    @Override
    public jB vT(int n) {
        if (n < 0 || n >= this.eO) {
            throw new ArithmeticException("Invalid bit position");
        }
        return BP.Le(this.lS & (1L << n ^ 0xFFFFFFFFFFFFFFFFL), this.eO);
    }

    @Override
    public jB KQ(int n) {
        return BP.Le(this.lS << n, this.eO);
    }

    @Override
    public jB LZ(int n) {
        long l2 = MathUtil.makeMask(this.eO);
        return BP.Le((this.lS & l2) >>> n, this.eO);
    }

    @Override
    public jB XV(int n) {
        return BP.Le(this.lS >> n, this.eO);
    }

    @Override
    public jB lo(int n) {
        if (n < 0) {
            return this.qo(-n);
        }
        long l2 = (1L << (n %= this.eO)) - 1L;
        long l3 = this.lS << n | this.lS >>> this.eO - n & l2;
        return BP.Le(l3, this.eO);
    }

    @Override
    public jB qo(int n) {
        if (n < 0) {
            return this.lo(-n);
        }
        long l2 = (1L << (n %= this.eO)) - 1L;
        long l3 = MathUtil.makeMask(this.eO);
        long l4 = (this.lS & l3) >>> n | (this.lS & l2) << this.eO - n;
        return BP.Le(l4, this.eO);
    }

    @Override
    public int _cmp(IEImm iEImm) {
        BP bP = this.qo(iEImm);
        return Long.compare(this.lS, bP.lS);
    }

    @Override
    public int _cmpU(IEImm iEImm) {
        BP bP = this.qo(iEImm);
        return Longs.compareUnsigned(this.lS, bP.lS);
    }

    @Override
    public jB kZ(int n) {
        if (n < 0) {
            throw new ArithmeticException("Invalid exponent");
        }
        long l2 = 1L;
        while (n > 0) {
            l2 *= this.lS;
            --n;
        }
        return jB.eO(l2, this.eO);
    }

    @Override
    public ICElement eO(EH eH2, Zp zp2) {
        if (this.Qx != null) {
            return this.Qx;
        }
        int n = this.eO;
        long l2 = this.lS;
        if (this.OP() != null && this.OP().getBitsize() != 0 && this.OP().getBitsize() != this.eO) {
            n = this.OP().getBitsize();
            l2 = n <= this.eO ? MathUtil.zeroExtend(l2, n) : MathUtil.zeroExtend(l2, this.eO);
        }
        if (n <= 32) {
            return zp2.XV().eO((int)l2);
        }
        return zp2.XV().eO(l2);
    }

    @Override
    public /* synthetic */ Object vT() {
        return this.XV();
    }

    @Override
    public /* synthetic */ IEImm _pow(int n) {
        return this.kZ(n);
    }

    @Override
    public /* synthetic */ IEImm _ror(int n) {
        return this.qo(n);
    }

    @Override
    public /* synthetic */ IEImm _rol(int n) {
        return this.lo(n);
    }

    @Override
    public /* synthetic */ IEImm _sar(int n) {
        return this.XV(n);
    }

    @Override
    public /* synthetic */ IEImm _shr(int n) {
        return this.LZ(n);
    }

    @Override
    public /* synthetic */ IEImm _shl(int n) {
        return this.KQ(n);
    }

    @Override
    public /* synthetic */ IEImm _clearbit(int n) {
        return this.vT(n);
    }

    @Override
    public /* synthetic */ IEImm _setbit(int n) {
        return this.TI(n);
    }

    @Override
    public /* synthetic */ IEImm _xor(IEImm iEImm) {
        return this.lo(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _or(IEImm iEImm) {
        return this.XV(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _and(IEImm iEImm) {
        return this.LZ(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _not() {
        return this.LZ();
    }

    @Override
    public /* synthetic */ IEImm _remU(IEImm iEImm) {
        return this.KQ(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _rem(IEImm iEImm) {
        return this.vT(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _divU(IEImm iEImm) {
        return this.TI(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _div(IEImm iEImm) {
        return this.ae(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _mulU(IEImm iEImm) {
        return this.lS(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _mul(IEImm iEImm) {
        return this.Qx(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _sub(IEImm iEImm) {
        return this.Le(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _add(IEImm iEImm) {
        return this.eO(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _neg() {
        return this.KQ();
    }

    @Override
    public /* synthetic */ IEImm expand(int n) {
        return this.ae(n);
    }

    @Override
    public /* synthetic */ IEImm truncate(int n) {
        return this.lS(n);
    }
}

