/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.logging;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TimeFormatter;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import java.io.IOException;
import org.apache.commons.text.StringEscapeUtils;

class StructuredLoggerHtmlGenerator {
    private static final String stylesheet;
    StructuredLogger log;
    boolean genTimestampInfo;
    boolean genCallerInfo;

    StructuredLoggerHtmlGenerator(StructuredLogger structuredLogger, boolean bl2, boolean bl3) {
        this.log = structuredLogger;
        this.genTimestampInfo = bl2;
        this.genCallerInfo = bl3;
    }

    public String generate() {
        StringBuilder stringBuilder = new StringBuilder(String.format("<!DOCTYPE html>\n<html>\n<head>\n<title>JEB Debug Log</title>\n<style>\n%s\n</style>\n</head>\n<body>\n", stylesheet));
        stringBuilder.append(String.format("<h1>%s</h1>\n", this.log.rootEntry.text));
        this.gen(this.log.rootEntry, stringBuilder, 0);
        stringBuilder.append("</body>\n</html>");
        return stringBuilder.toString();
    }

    private void gen(StructuredLogger.Entry entry, StringBuilder stringBuilder, int n) {
        if (entry.sub == null) {
            String string;
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = new StringBuilder();
            if (entry.importance != 10) {
                if (this.genTimestampInfo) {
                    stringBuilder2.append("<span class='timestamp'>(").append(TimeFormatter.formatTimestampDelta(entry.timestamp - this.log.ts0)).append(")</span> ");
                }
                if (this.genCallerInfo) {
                    if (entry.caller == null) {
                        stringBuilder3.append("?");
                    } else {
                        stringBuilder3.append("<span class='caller'>[").append(this.escape(entry.caller)).append("]</span> ");
                    }
                }
            }
            String string2 = "";
            String string3 = this.importanceToClass(entry.importance);
            if (!string3.isEmpty()) {
                string2 = string2 + string3;
            }
            if (!(string = this.levelToClass(entry.level)).isEmpty()) {
                string2 = string2 + " " + string;
            }
            StringBuilder stringBuilder4 = new StringBuilder();
            stringBuilder4.append("<span class='").append(string2).append("'>");
            stringBuilder4.append((CharSequence)stringBuilder2).append((CharSequence)stringBuilder3).append(this.escape(entry.text)).append("</span><br>");
            this.appendLine(stringBuilder, n, stringBuilder4);
            return;
        }
        for (StructuredLogger.Entry entry2 : entry.sub) {
            if (entry2.sub == null) {
                this.gen(entry2, stringBuilder, n + 1);
                continue;
            }
            String string = entry2.open ? " open" : "";
            this.appendLine(stringBuilder, n + 1, "<details%s><summary>%s</summary>", string, this.escape(entry2.text));
            this.appendLine(stringBuilder, n + 1, "<div class='logsection'>");
            this.gen(entry2, stringBuilder, n + 1);
            this.appendLine(stringBuilder, n + 1, "</div>");
            this.appendLine(stringBuilder, n + 1, "</details>");
        }
    }

    private String importanceToClass(int n) {
        switch (n) {
            case -1: {
                return "logimp-small";
            }
            case 0: {
                return "logimp-normal";
            }
            case 1: {
                return "logimp-highlight";
            }
            case 2: {
                return "logimp-section";
            }
            case 3: {
                return "logimp-subtitle";
            }
            case 4: {
                return "logimp-title";
            }
            case 5: {
                return "logimp-chapter";
            }
        }
        return "";
    }

    private String levelToClass(int n) {
        switch (n) {
            case 60: {
                return "loglevel-critical";
            }
            case 50: {
                return "loglevel-error";
            }
            case 40: {
                return "loglevel-warn";
            }
            case 30: {
                return "loglevel-info";
            }
            case 20: {
                return "loglevel-debug";
            }
            case 10: {
                return "loglevel-trace";
            }
        }
        return "";
    }

    private void appendLine(StringBuilder stringBuilder, int n, String string, Object ... objectArray) {
        this.appendLine(stringBuilder, n, objectArray == null || objectArray.length == 0 ? string : String.format(string, objectArray));
    }

    private void appendLine(StringBuilder stringBuilder, int n, CharSequence charSequence) {
        stringBuilder.append(Strings.generate(' ', n * 2));
        stringBuilder.append(charSequence);
        stringBuilder.append('\n');
    }

    private String escape(String string) {
        string = StringEscapeUtils.escapeHtml4((String)string);
        string = string.replace("\t", "    ");
        StringBuilder stringBuilder = new StringBuilder();
        for (int j = 0; j < string.length(); ++j) {
            char c = string.charAt(j);
            if (c == ' ' && j + 1 < string.length() && string.charAt(j + 1) == ' ') {
                stringBuilder.append("&nbsp;");
                continue;
            }
            stringBuilder.append(c);
        }
        string = stringBuilder.toString();
        string = string.replaceAll("(\r\n|\r|\n)", "<br>");
        return string;
    }

    static {
        try {
            stylesheet = Strings.decodeUTF8(IO.readInputStream(StructuredLogger.class.getResourceAsStream("slstyles.css")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot retrieve html style sheet for the structured logger", iOException);
        }
    }
}

