/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.zip.fsr;

import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.io.ChannelUtil;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public class LocalFileHeader {
    int versionRequired;
    int flags;
    int compressionMethod;
    int modTime;
    int modDate;
    int crc;
    int compressedSize;
    int filesize;
    byte[] filename = ArrayUtil.NO_BYTE;
    byte[] extra = ArrayUtil.NO_BYTE;
    int entrysize;
    boolean corrupted;

    public static LocalFileHeader parse(FileChannel fileChannel, int n) throws IOException {
        LocalFileHeader localFileHeader = new LocalFileHeader();
        try {
            ByteBuffer byteBuffer;
            localFileHeader.versionRequired = ChannelUtil.getLEShort(fileChannel, n + 4) & 0xFFFF;
            localFileHeader.flags = ChannelUtil.getLEShort(fileChannel, n + 6) & 0xFFFF;
            localFileHeader.compressionMethod = ChannelUtil.getLEShort(fileChannel, n + 8) & 0xFFFF;
            localFileHeader.modTime = ChannelUtil.getLEShort(fileChannel, n + 10) & 0xFFFF;
            localFileHeader.modDate = ChannelUtil.getLEShort(fileChannel, n + 12) & 0xFFFF;
            localFileHeader.crc = ChannelUtil.getLEInt(fileChannel, n + 14);
            localFileHeader.compressedSize = ChannelUtil.getLEInt(fileChannel, n + 18);
            localFileHeader.filesize = ChannelUtil.getLEInt(fileChannel, n + 22);
            int n2 = ChannelUtil.getLEShort(fileChannel, n + 26) & 0xFFFF;
            int n3 = ChannelUtil.getLEShort(fileChannel, n + 28) & 0xFFFF;
            if (n2 > 0) {
                byteBuffer = ChannelUtil.readBestEffort(fileChannel, n + 30, n2, false, null);
                if (byteBuffer.limit() != n2) {
                    localFileHeader.corrupted = true;
                }
                localFileHeader.filename = byteBuffer.array();
            }
            if (n3 > 0) {
                byteBuffer = ChannelUtil.readBestEffort(fileChannel, n + 30 + n2, n3, false, null);
                if (byteBuffer.limit() != n3) {
                    localFileHeader.corrupted = true;
                }
                localFileHeader.extra = byteBuffer.array();
            }
            localFileHeader.entrysize = 30 + n2 + n3;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException);
        }
        return localFileHeader;
    }

    public String getFilename() {
        return new String(this.filename, Charset.forName("UTF-8"));
    }

    public boolean isEncrypted() {
        return (this.flags & 1) != 0;
    }

    public String toString() {
        return String.format("%s:%d(%d)%s", this.getFilename(), this.filesize, this.compressionMethod, this.corrupted ? "[BAD!]" : "");
    }
}

