/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LongLEB128 {
    public static void writeULEB128(OutputStream outputStream, long l2) throws IOException {
        if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
            outputStream.write((int)l2);
        } else if ((l2 & 0xFFFFFFFFFFFFC000L) == 0L) {
            outputStream.write(0x80 | (int)(l2 & 0x7FL));
            outputStream.write((int)(l2 >>> 7) & 0x7F);
        } else if ((l2 & 0xFFFFFFFFFFE00000L) == 0L) {
            outputStream.write(0x80 | (int)(l2 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 7 & 0x7FL));
            outputStream.write((int)(l2 >>> 14) & 0x7F);
        } else if ((l2 & 0xFFFFFFFFF0000000L) == 0L) {
            outputStream.write(0x80 | (int)(l2 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 7 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 14 & 0x7FL));
            outputStream.write((int)(l2 >>> 21) & 0x7F);
        } else if ((l2 & 0xFFFFFFF800000000L) == 0L) {
            outputStream.write(0x80 | (int)(l2 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 7 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 14 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 21 & 0x7FL));
            outputStream.write((int)(l2 >>> 28) & 0x7F);
        } else if ((l2 & 0xFFFFFC0000000000L) == 0L) {
            outputStream.write(0x80 | (int)(l2 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 7 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 14 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 21 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 28 & 0x7FL));
            outputStream.write((int)(l2 >>> 35) & 0x7F);
        } else if ((l2 & 0xFFFE000000000000L) == 0L) {
            outputStream.write(0x80 | (int)(l2 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 7 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 14 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 21 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 28 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 35 & 0x7FL));
            outputStream.write((int)(l2 >>> 42) & 0x7F);
        } else if ((l2 & 0xFF00000000000000L) == 0L) {
            outputStream.write(0x80 | (int)(l2 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 7 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 14 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 21 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 28 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 35 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 42 & 0x7FL));
            outputStream.write((int)(l2 >>> 49) & 0x7F);
        } else if ((l2 & Long.MIN_VALUE) == 0L) {
            outputStream.write(0x80 | (int)(l2 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 7 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 14 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 21 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 28 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 35 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 42 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 49 & 0x7FL));
            outputStream.write((int)(l2 >>> 56) & 0x7F);
        } else {
            outputStream.write(0x80 | (int)(l2 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 7 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 14 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 21 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 28 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 35 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 42 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 49 & 0x7FL));
            outputStream.write(0x80 | (int)(l2 >>> 56 & 0x7FL));
            outputStream.write((int)(l2 >>> 63) & 0x7F);
        }
    }

    public static long readULEB128(InputStream inputStream) throws IOException {
        long l2 = 0L;
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while ((n & 0x80) != 0) {
            if (n3 == 10) {
                throw new IOException("Illegal ULEB128-encoded integer");
            }
            n = inputStream.read();
            if ((long)n == -1L) {
                throw new IOException("Not enough data");
            }
            l2 |= (long)(n & 0x7F) << n2;
            n2 += 7;
            ++n3;
        }
        return l2;
    }

    public static DecodedLong decodeULEB128(InputStream inputStream) throws IOException {
        DecodedLong decodedLong = new DecodedLong();
        long l2 = 0L;
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while ((n & 0x80) != 0) {
            if (n3 == 10) {
                throw new IOException("Illegal ULEB128-encoded integer");
            }
            n = inputStream.read();
            ++decodedLong.encodedSize;
            if ((long)n == -1L) {
                throw new IOException("Not enough data");
            }
            l2 |= (long)(n & 0x7F) << n2;
            n2 += 7;
            ++n3;
        }
        decodedLong.value = l2;
        return decodedLong;
    }

    public static class DecodedLong {
        public long value;
        public int encodedSize = 0;
    }
}

