/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInit;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Ser
public class SynchronizedLinkedMap<K, V> {
    @SerId(value=1)
    private LinkedHashMap<K, V> map0 = new LinkedHashMap();
    @SerTransient
    private Map<K, V> map;

    @SerCustomInit
    private void init() {
        this.map = Collections.synchronizedMap(this.map0);
    }

    public SynchronizedLinkedMap() {
        this.init();
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(K k2) {
        return this.map.containsKey(k2);
    }

    public boolean containsValue(V v2) {
        return this.map.containsValue(v2);
    }

    public V get(K k2) {
        return this.map.get(k2);
    }

    public V put(K k2, V v2) {
        if (k2 == null) {
            throw new NullPointerException("Illegal null key");
        }
        if (v2 == null) {
            throw new NullPointerException("Illegal null value");
        }
        return this.map.put(k2, v2);
    }

    public V remove(K k2) {
        return this.map.remove(k2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<K> copyOfKeys() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return new LinkedHashSet<K>(this.map.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<V> copyOfValues() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return new ArrayList<V>(this.map.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K firstKey() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return this.map.keySet().iterator().next();
        }
    }

    public String toString() {
        return this.map.toString();
    }
}

