/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Maps {
    public static <K, V> V get(Map<K, V> map, K k2) {
        if (map == null) {
            return null;
        }
        return map.get(k2);
    }

    public static <K, V> V get(Map<K, V> map, K k2, V v2) {
        if (map == null || !map.containsKey(k2)) {
            return v2;
        }
        return map.get(k2);
    }

    public static <K, V> HashMap<K, V> toMap(K k2, V v2) {
        return (HashMap)Maps.toMap(k2, v2, null);
    }

    public static <K, V> Map<K, V> toMap(K k2, V v2, Class<? extends Map> clazz) {
        Map<K, V> map = null;
        if (clazz != null) {
            try {
                map = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (map == null) {
            map = new HashMap<K, V>();
        }
        map.put(k2, v2);
        return map;
    }

    public static <K, V extends Comparable<V>> List<V> getSortedValues(Map<K, V> map, final boolean bl2) {
        ArrayList<V> arrayList = new ArrayList<V>(map.values());
        Collections.sort(arrayList, new Comparator<V>(){

            @Override
            public int compare(V v2, V v3) {
                int n = v2.compareTo(v3);
                return bl2 ? n : -n;
            }
        });
        return arrayList;
    }

    public static <K, V extends Comparable<V>> List<V> getSortedValues(Map<K, V> map) {
        return Maps.getSortedValues(map, true);
    }

    public static <K, V extends Comparable<V>> LinkedHashMap<K, V> createSortedMapByValue(Map<K, V> map, final boolean bl2) {
        ArrayList<Map.Entry<K, V>> arrayList = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> entry, Map.Entry<K, V> entry2) {
                int n = ((Comparable)entry.getValue()).compareTo(entry2.getValue());
                return bl2 ? n : -n;
            }
        });
        LinkedHashMap linkedHashMap = new LinkedHashMap(arrayList.size());
        for (Map.Entry entry : arrayList) {
            linkedHashMap.put(entry.getKey(), entry.getValue());
        }
        return linkedHashMap;
    }

    public static <V> String putNoOverwrite(Map<String, V> map, String string, V v2) {
        String string2 = string;
        int n = 0;
        while (map.containsKey(string2)) {
            string2 = Strings.safe(string, "null") + "." + ++n;
        }
        map.put(string2, v2);
        return string2;
    }
}

