/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class SystemUtil {
    private static final ILogger logger = GlobalLog.getLogger(SystemUtil.class);
    public static final String javavendor = System.getProperty("java.vendor");
    public static final String javaversion = System.getProperty("java.version");
    public static final String osname = System.getProperty("os.name");
    public static final String osarch = System.getProperty("os.arch");
    public static final String osversion = System.getProperty("os.version");

    public static String getJavaVendor() {
        return javavendor;
    }

    public static String getJavaVersion() {
        return javaversion;
    }

    public static String getOsName() {
        return osname;
    }

    public static String getOsArchitecture() {
        return osarch;
    }

    public static String getOsVersion() {
        return osversion;
    }

    public static int getMajorJavaVersion() {
        return SystemUtil.parseMajorJavaVersion(javaversion);
    }

    public static int parseMajorJavaVersion(String string) {
        int n;
        int n2 = 0;
        int n3 = string.length();
        if (string.startsWith("1.")) {
            n2 = 2;
        }
        if ((n = string.indexOf(46, n2)) >= 0) {
            n3 = n;
        }
        if (n2 > 0 || n3 < string.length()) {
            try {
                return Integer.parseInt(string.substring(n2, n3));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        logger.warn("Unsupported Java version string: \"%s\"", string);
        return 0;
    }
}

