/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.HashMap;
import java.util.Map;

@Ser
public class Flags {
    @SerId(value=1)
    private int flags;
    @SerId(value=2)
    private int allowed;
    @SerId(value=3)
    private Map<Integer, String> namemap;

    public Flags() {
        this(0);
    }

    public Flags(int n) {
        this(n, -1, null);
    }

    public Flags(int n, int n2, Map<Integer, String> map) {
        this.flags = n;
        this.allowed = n2;
        if (map != null) {
            for (int n3 : map.keySet()) {
                String string;
                if (!this.isValidBit(n3) || Strings.isBlank(string = map.get(n3))) continue;
                if (this.namemap == null) {
                    this.namemap = new HashMap<Integer, String>();
                }
                this.namemap.put(n3, string);
            }
        }
    }

    public void verify(int n) {
        if ((n | this.allowed) != this.allowed) {
            throw new IllegalStateException(String.format("Illegal flags: 0x%X", n & ~this.allowed));
        }
    }

    public int get() {
        return this.flags;
    }

    public boolean set(int n) {
        this.verify(n);
        if (n == this.flags) {
            return false;
        }
        this.flags = n;
        return true;
    }

    public boolean isValidBit(int n) {
        return (this.allowed & 1 << n) != 0;
    }

    public boolean testBit(int n) {
        if (n < 0 || n > 31) {
            throw new IllegalArgumentException("Bit index out of range: " + n);
        }
        return (this.flags & 1 << n) != 0;
    }

    public boolean has(int n) {
        return (this.flags & n) == n;
    }

    public boolean hasSome(int n) {
        return (this.flags & n) != 0;
    }

    public boolean hasNone(int n) {
        return (this.flags & n) == 0;
    }

    public boolean addTo(int n) {
        this.verify(n);
        if (this.has(n)) {
            return false;
        }
        this.flags |= n;
        return true;
    }

    public boolean removeFrom(int n) {
        if (this.hasNone(n)) {
            return false;
        }
        this.flags &= ~n;
        return true;
    }

    public boolean update(int n, boolean bl2) {
        return bl2 ? this.addTo(n) : this.removeFrom(n);
    }

    public String toString() {
        return String.format("0x%08X", this.flags);
    }
}

