/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.xml;

import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.code.AssemblyItem;
import com.pnfsoftware.jeb.core.output.code.CodeDocument;
import com.pnfsoftware.jeb.core.output.code.CodeLine;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.corei.parsers.xml.ej;
import com.pnfsoftware.jeb.corei.parsers.xml.pX;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class OI
extends CodeDocument {
    private static final ILogger eO = GlobalLog.getLogger(OI.class);
    private ej Le;
    private pX Qx;

    public OI(pX pX2) {
        this.Qx = pX2;
        this.eO(pX2);
    }

    @Override
    public long getAnchorCount() {
        return 1L;
    }

    @Override
    public String coordinatesToAddress(ICoordinates iCoordinates, AddressConversionPrecision addressConversionPrecision) {
        if (iCoordinates == null) {
            return null;
        }
        int n = iCoordinates.getLineDelta();
        if (this.Le == null || n < 0 || n >= this.Le.getLines().size()) {
            return null;
        }
        CodeLine codeLine = this.Le.getLines().get(n);
        List<AssemblyItem> list = codeLine.getItems();
        for (AssemblyItem assemblyItem : list) {
            if (assemblyItem.getOffset() > iCoordinates.getColumnOffset() || iCoordinates.getColumnOffset() >= assemblyItem.getOffsetEnd()) continue;
            return this.Qx.getAddressOfItem(assemblyItem.getItemId());
        }
        return null;
    }

    @Override
    public ICoordinates addressToCoordinates(String string) {
        return null;
    }

    @Override
    public ITextDocumentPart getDocumentPart(long l2, int n, int n2) {
        return this.Le;
    }

    private void eO(pX pX2) {
        this.Le = new ej(0L);
        this.Le.setIndentationString("  ");
        Document document = pX2.getDocument();
        this.Le.registerAnchor("wholeDocumentAnchor");
        this.eO((Node)document);
        this.Le.eol();
    }

    void eO(Node node) {
        if (!this.Le.isCurrentLineEmpty()) {
            this.Le.eol();
        }
        if (node instanceof Document) {
            this.eO((Document)node);
        } else if (node instanceof Element) {
            this.eO((Element)node);
        } else if (node instanceof CharacterData) {
            this.eO((CharacterData)node);
        }
    }

    void eO(Document document) {
        String string;
        this.Le.append("<?xml");
        this.Le.space();
        String string2 = document.getXmlVersion();
        if (string2 != null) {
            this.Le.appendAndRecord("version", ItemClassIdentifiers.MARKUP_ATTRIBUTE_NAME);
            this.Le.append("=\"");
            this.Le.appendAndRecord(string2, ItemClassIdentifiers.MARKUP_ATTRIBUTE_VALUE);
            this.Le.append("\"");
            this.Le.space();
        }
        if ((string = document.getXmlEncoding()) != null) {
            this.Le.appendAndRecord("encoding", ItemClassIdentifiers.MARKUP_ATTRIBUTE_NAME);
            this.Le.append("=\"");
            this.Le.appendAndRecord(string, ItemClassIdentifiers.MARKUP_ATTRIBUTE_VALUE);
            this.Le.append("\"");
        }
        this.Le.append("?>");
        NodeList nodeList = document.getChildNodes();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Node node = nodeList.item(j);
            this.eO(node);
        }
    }

    private long eO(long l2, int n, boolean bl2) {
        if (n >= 128) {
            return 0L;
        }
        return l2 | (long)(n << 1) | (long)(bl2 ? 0 : 1);
    }

    private long eO(long l2) {
        return l2 | 0xC0L;
    }

    private long Le(long l2) {
        return l2 | 0xC1L;
    }

    private long eO(long l2, int n) {
        if (n >= 64) {
            return 0L;
        }
        return l2 | 0x80L | (long)n;
    }

    private long Le(Node node) {
        long l2 = 0L;
        Object object = node.getUserData("itemId");
        if (object != null) {
            l2 = (long)((Integer)object).intValue() << 8;
        }
        return l2;
    }

    void eO(Element element) {
        Object object;
        long l2 = this.Le(element);
        String string = element.getTagName();
        this.Le.append("<");
        this.Le.appendAndRecord(string, ItemClassIdentifiers.MARKUP_ELEMENT, this.eO(l2));
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int j = 0; j < namedNodeMap.getLength(); ++j) {
            Attr attr = (Attr)namedNodeMap.item(j);
            object = attr.getName();
            String string2 = attr.getValue();
            this.Le.space();
            this.Le.appendAndRecord((String)object, ItemClassIdentifiers.MARKUP_ATTRIBUTE_NAME, this.eO(l2, j, true));
            this.Le.append("=\"");
            this.Le.appendAndRecord(string2, ItemClassIdentifiers.MARKUP_ATTRIBUTE_VALUE, this.eO(l2, j, false));
            this.Le.append("\"");
        }
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() == 0) {
            this.Le.append(" />");
        } else {
            this.Le.append(">");
            this.Le.incrementIndentationLevel();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                object = nodeList.item(j);
                this.eO((Node)object);
            }
            this.Le.decrementIndentationLevel();
            this.Le.append("</");
            this.Le.appendAndRecord(string, ItemClassIdentifiers.MARKUP_ELEMENT, this.Le(l2));
            this.Le.append(">");
        }
    }

    void eO(CharacterData characterData) {
        String string = characterData.getTextContent();
        if (string.isEmpty()) {
            return;
        }
        boolean bl2 = false;
        if (characterData instanceof Comment) {
            this.Le.append("<!--");
        } else if (characterData instanceof CDATASection) {
            this.Le.append("<![CDATA[");
        } else if (characterData instanceof Text) {
            string = this.eO(string);
            bl2 = true;
        } else {
            throw new RuntimeException();
        }
        bl2 = true;
        long l2 = this.Le(characterData.getParentNode());
        if (bl2) {
            String[] stringArray = string.split("( |\n)", -1);
            int n = 0;
            for (String string2 : stringArray) {
                if (string2.isEmpty()) continue;
                this.Le.appendAndRecord(string2, ItemClassIdentifiers.MARKUP_TEXT, this.eO(l2, n));
                if (++n >= stringArray.length) continue;
                this.Le.space();
            }
        } else {
            int n = this.Le.getIndentationLevel();
            this.Le.indentReset();
            String[] stringArray = Strings.splitLines(string);
            int n2 = 0;
            for (String string3 : stringArray) {
                if (string3.isEmpty()) continue;
                this.Le.appendAndRecord(string3, ItemClassIdentifiers.MARKUP_TEXT, this.eO(l2, n2));
                if (++n2 >= stringArray.length) continue;
                this.Le.space();
            }
            this.Le.setIndentationLevel(n);
        }
        if (characterData instanceof Comment) {
            this.Le.append("-->");
        } else if (characterData instanceof CDATASection) {
            this.Le.append("]]>");
        }
    }

    private String eO(String string) {
        char c;
        int n;
        int n2;
        for (n2 = 0; n2 < string.length() && Character.isWhitespace((char)(n = string.charAt(n2))); ++n2) {
        }
        for (n = string.length() - 1; n > n2 && Character.isWhitespace(c = string.charAt(n)); --n) {
        }
        return string.substring(n2, n + 1);
    }
}

