/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.xapk;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.FileInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.xapk.OI;
import com.pnfsoftware.jeb.util.encoding.zip.ZipBrowser;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class XApkIdentifier
extends AbstractUnitIdentifier {
    private static final ILogger logger = GlobalLog.getLogger(XApkIdentifier.class);
    public static final String TYPE = "xapk";
    static final String manifestName = "manifest.json";
    static final String iconName = "icon.png";

    public XApkIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("APK Extension file parser", "Android X-APK (extension) parser", "PNF Software", Version.create(1, 0, 1));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator) {
        block19: {
            if (!(iInput instanceof FileInput)) {
                return false;
            }
            if (!XApkIdentifier.checkBytes(iInput, 0, 80, 75, 3, 4)) {
                return false;
            }
            ZipBrowser zipBrowser = null;
            try {
                File file = ((FileInput)iInput).getFile();
                zipBrowser = new ZipBrowser(file);
                if (zipBrowser.getEntry(manifestName) == null) break block19;
                byte[] byArray = zipBrowser.readEntry(manifestName);
                JSONParser jSONParser = new JSONParser();
                try {
                    Object object = jSONParser.parse(Strings.decodeUTF8(byArray));
                    boolean bl2 = ((Map)object).get("xapk_version") != null;
                    return bl2;
                }
                catch (ParseException parseException) {
                    try {
                        logger.catchingSilent(parseException);
                    }
                    catch (IOException iOException) {
                        logger.catchingSilent(iOException);
                        boolean bl3 = false;
                        return bl3;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (zipBrowser != null) {
                    try {
                        zipBrowser.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return false;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator) {
        OI oI = new OI(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return oI;
    }
}

