/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.winpe;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.winpe.Io;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;

public class PEIdentifier
extends AbstractUnitIdentifier {
    public static final String TYPE = "winpe";
    public static final short PortableExecutableMagicLE = 23117;
    public static final short PortableExecutableMagicBE = 19802;

    public PEIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("PE loader", "Windows Portable Executable (PE) code object parser", "PNF Software", Version.create(0, 0, 1));
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator) {
        if (!PEIdentifier.checkBytes(iInput, 0, 77, 90)) {
            return false;
        }
        ByteBuffer byteBuffer = iInput.getHeader();
        if (byteBuffer.limit() < 64) {
            return false;
        }
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = byteBuffer.getInt(60);
        if (n < 0 || (long)(n + 4) > iInput.getCurrentSize()) {
            return false;
        }
        return PEIdentifier.checkBytes(iInput, n, 80, 69, 0, 0);
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator) {
        Io io = new Io(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return io;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPE64(IInput iInput) {
        byte[] byArray = new byte[64];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        try (SeekableByteChannel seekableByteChannel = iInput.getChannel();){
            seekableByteChannel.position(0L);
            seekableByteChannel.read(byteBuffer);
            if (byteBuffer.getShort(0) != 23117) {
                throw new RuntimeException();
            }
            int n = byteBuffer.getInt(60);
            if (n < 0) {
                throw new RuntimeException();
            }
            seekableByteChannel.position(n);
            byteBuffer.position(0);
            int n2 = seekableByteChannel.read(byteBuffer);
            if (n2 < 26) {
                throw new RuntimeException();
            }
            if (byteBuffer.getInt(0) != 17744) {
                throw new RuntimeException();
            }
            short s2 = byteBuffer.getShort(24);
            switch (s2) {
                case 267: {
                    boolean bl2 = false;
                    return bl2;
                }
                case 523: {
                    boolean bl3 = true;
                    return bl3;
                }
            }
            throw new RuntimeException();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

