/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.elf;

import com.pnfsoftware.jeb.core.units.codeobject.IELFHeader;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.SubsystemType;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@Ser
public class cg
implements IELFHeader {
    @SerId(value=1)
    int eO;
    @SerId(value=2)
    int Le;
    @SerId(value=3)
    int Qx;
    @SerId(value=4)
    int lS;
    @SerId(value=5)
    int ae;
    @SerId(value=6)
    int TI;
    @SerId(value=7)
    int vT;
    @SerId(value=8)
    int KQ;
    @SerId(value=9)
    long LZ;
    @SerId(value=10)
    long XV;
    @SerId(value=11)
    long lo;
    @SerId(value=12)
    int qo;
    @SerId(value=13)
    int kZ;
    @SerId(value=14)
    int Kg;
    @SerId(value=15)
    int DA;
    @SerId(value=16)
    int aO;
    @SerId(value=17)
    int gU;
    @SerId(value=18)
    int qb;
    @SerId(value=19)
    boolean cb;
    @SerId(value=20)
    boolean hd;

    @Override
    public int getBitsize() {
        return this.hd ? 64 : 32;
    }

    @Override
    public Endianness getEndianness() {
        return this.cb ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN;
    }

    @Override
    public int getOsabi() {
        return this.lS;
    }

    @Override
    public int getAbiVersion() {
        return this.ae;
    }

    @Override
    public int getType() {
        return this.TI;
    }

    @Override
    public int getMachine() {
        return this.vT;
    }

    @Override
    public long getEntry() {
        return this.LZ;
    }

    @Override
    public long getProgramHeaderTableOffet() {
        return this.XV;
    }

    @Override
    public long getSectionHeaderTableOffset() {
        return this.lo;
    }

    @Override
    public int getFlags() {
        return this.qo;
    }

    @Override
    public int getHeaderSize() {
        return this.kZ;
    }

    @Override
    public int getProgramHeaderTableEntrySize() {
        return this.Kg;
    }

    @Override
    public int getProgramHeaderTableEntryNumber() {
        return this.DA;
    }

    @Override
    public int getSectionHeaderTableEntrySize() {
        return this.aO;
    }

    @Override
    public int getSectionHeaderTableEntryNumber() {
        return this.gU;
    }

    public static cg eO(ByteBuffer byteBuffer) {
        cg cg2 = new cg();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        cg2.cb = false;
        cg2.hd = false;
        byteBuffer.position(4);
        cg2.eO = byteBuffer.get() & 0xFF;
        cg2.Le = byteBuffer.get() & 0xFF;
        cg2.Qx = byteBuffer.get() & 0xFF;
        cg2.lS = byteBuffer.get() & 0xFF;
        cg2.ae = byteBuffer.get() & 0xFF;
        if (cg2.eO == 2) {
            cg2.hd = true;
        } else if (cg2.eO != 1) {
            throw new RuntimeException("Illegal ELF file: eiClass=" + cg2.eO);
        }
        if (cg2.Le == 2) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            cg2.cb = true;
        } else if (cg2.Le != 1) {
            throw new RuntimeException();
        }
        byteBuffer.position(byteBuffer.position() + 7);
        cg2.TI = byteBuffer.getShort() & 0xFFFF;
        cg2.vT = byteBuffer.getShort() & 0xFFFF;
        cg2.KQ = byteBuffer.getInt();
        cg2.LZ = cg2.hd ? byteBuffer.getLong() : (long)byteBuffer.getInt() & 0xFFFFFFFFL;
        cg2.XV = cg2.hd ? byteBuffer.getLong() : (long)byteBuffer.getInt() & 0xFFFFFFFFL;
        cg2.lo = cg2.hd ? byteBuffer.getLong() : (long)byteBuffer.getInt() & 0xFFFFFFFFL;
        cg2.qo = byteBuffer.getInt();
        cg2.kZ = byteBuffer.getShort() & 0xFFFF;
        cg2.Kg = byteBuffer.getShort() & 0xFFFF;
        cg2.DA = byteBuffer.getShort() & 0xFFFF;
        cg2.aO = byteBuffer.getShort() & 0xFFFF;
        cg2.gU = byteBuffer.getShort() & 0xFFFF;
        cg2.qb = byteBuffer.getShort() & 0xFFFF;
        return cg2;
    }

    public ProcessorType eO() {
        switch (this.vT) {
            case 62: {
                return ProcessorType.X86_64;
            }
            case 3: {
                return ProcessorType.X86;
            }
            case 40: {
                if (this.hd) {
                    throw new RuntimeException();
                }
                return ProcessorType.ARM;
            }
            case 183: {
                if (!this.hd) {
                    throw new RuntimeException();
                }
                return ProcessorType.ARM64;
            }
            case 8: {
                return this.hd ? ProcessorType.MIPS64 : ProcessorType.MIPS;
            }
            case 83: {
                return ProcessorType.AVR;
            }
            case 185: {
                return ProcessorType.AVR32;
            }
        }
        return null;
    }

    public SubsystemType Le() {
        switch (this.lS) {
            default: 
        }
        return null;
    }
}

