/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.asm.decompiler.explorer;

import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerUnit;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.corei.parsers.asm.decompiler.explorer.Io;
import com.pnfsoftware.jeb.corei.parsers.asm.decompiler.explorer.Ol;
import com.pnfsoftware.jeb.corei.parsers.asm.decompiler.explorer.Rf;
import com.pnfsoftware.jeb.corei.parsers.asm.decompiler.explorer.pX;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.CF;
import com.pnfsoftware.jebglobal.Yo;
import com.pnfsoftware.jebglobal.Zp;
import com.pnfsoftware.jebglobal.xs;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DecompilerExplorer {
    private static final ILogger eO;
    private static List<String> Le;
    private static String Qx;
    private static String lS;
    private static String ae;

    public static void main(String[] stringArray) throws JebException, IOException {
        if (stringArray.length == 2) {
            Qx = lS = stringArray[0];
            ae = stringArray[1];
        } else if (stringArray.length == 1) {
            Qx = lS = stringArray[0];
        }
        int n = 2;
        boolean bl2 = true;
        String string = "";
        if (n == 0) {
            string = "_no_optis";
        } else if (n == 1) {
            string = "_no_loop_optis";
        } else if (n == 10) {
            string = "_no_loop_no_extra_return_optis";
        } else if (n == 2) {
            string = "_all_optis";
        }
        if (lS != null && ae == null) {
            for (File file : new File(lS).listFiles()) {
                if (file.getName().endsWith(".jdb2") || file.getName().endsWith(".txt")) continue;
                DecompilerExplorer.eO(lS, file.getName(), bl2, string);
            }
        } else if (lS != null && ae != null) {
            DecompilerExplorer.eO(lS, ae, bl2, string);
        } else {
            eO.warn("No file to process", new Object[0]);
        }
    }

    private static boolean eO(String string, String string2, boolean bl2, String string3) throws JebException, IOException {
        Object object;
        eO.i("%n>> Starting analysis of %s%n", string2);
        GlobalLog.addGlobalFilter("com.pnfsoftware.jeb.corei.parsers.asm.analyzer", Integer.MAX_VALUE);
        GlobalLog.addGlobalFilter("com.pnfsoftware.jeb.corei.parsers.elf", Integer.MAX_VALUE);
        GlobalLog.addGlobalFilter("com.pnfsoftware.jeb.corei.parsers.winpe", Integer.MAX_VALUE);
        GlobalLog.addGlobalFilter("com.pnfsoftware.jeb.corei.parsers.GenericProcessor", Integer.MAX_VALUE);
        Ol ol2 = new Ol(string, string2, bl2, string3);
        List<IUnit> list = ol2.eO();
        if (list == null || list.isEmpty()) {
            eO.i("Problem with root unit creation", new Object[0]);
            return false;
        }
        Yo yo = UnitUtil.findChildByType(list.get(0), Yo.class, false, 0);
        if (yo == null) {
            eO.i("Cannot find PBCU", new Object[0]);
            return false;
        }
        if (!yo.process()) {
            eO.i("Unit processing failed", new Object[0]);
            return false;
        }
        INativeDecompilerUnit iNativeDecompilerUnit = (INativeDecompilerUnit)DecompilerHelper.getDecompiler(yo);
        pX pX2 = new pX();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        List<xs> list2 = yo.getInternalMethods();
        if (list2.size() > 400) {
            eO.i("Too many routines (%d), no decompilation", list2.size());
            return false;
        }
        int n = 1;
        for (xs object22 : list2) {
            List<Rf> list3;
            eO.i("Processing routine %s (%d/%d)...", object22.getName(true), n, list2.size());
            ++n;
            if (Le.contains(object22.getName(true))) {
                eO.i("Blacklisted!", new Object[0]);
                hashMap.put(object22.getAddress(), null);
                continue;
            }
            if (object22.KQ().getCFG().getEffectiveSize() > 4096) {
                eO.i("Routine is too large (%08x), no decompilation", object22.KQ().getCFG().getEffectiveSize());
            }
            boolean bl3 = false;
            try {
                GlobalLog.addGlobalFilter("", Integer.MAX_VALUE);
                object = iNativeDecompilerUnit.getDecompiledUnit(object22.getAddress());
                if (object == null) {
                    object = iNativeDecompilerUnit.decompile(object22.getAddress());
                    bl3 = true;
                }
                GlobalLog.removeGlobalFilter("");
            }
            catch (RuntimeException runtimeException) {
                GlobalLog.removeGlobalFilter("");
                eO.i("Fail: %s", runtimeException.getMessage());
                list3 = new Io();
                ((Io)((Object)list3)).eO(runtimeException.getMessage());
                Object object2 = new ArrayList();
                object2.add(list3);
                hashMap.put(object22.getAddress(), object2);
                continue;
            }
            if (object == null) {
                eO.i("Fail: empty source code", new Object[0]);
                hashMap.put(object22.getAddress(), null);
                continue;
            }
            if (((CF)object).Le() instanceof Zp) {
                Object runtimeException = (Zp)((CF)object).Le();
                pX2.eO((Zp)runtimeException);
                list3 = pX2.eO();
                hashMap.put(object22.getAddress(), list3);
                pX2.Le();
            }
            eO.i("Done! (decompilation=%s)", bl3 ? "yes" : "no");
        }
        if (bl2) {
            ol2.Le();
        }
        String string4 = string2 + string3 + ".txt";
        File file = new File(Qx, string4);
        object = new StringBuilder();
        for (Object runtimeException : hashMap.keySet()) {
            ((StringBuilder)object).append("== Routine ").append((String)runtimeException);
            ((StringBuilder)object).append(System.getProperty("line.separator"));
            if (hashMap.get(runtimeException) == null) {
                ((StringBuilder)object).append("Decompilation failed!");
                ((StringBuilder)object).append(System.getProperty("line.separator"));
                continue;
            }
            if (((List)hashMap.get(runtimeException)).size() == 0) {
                ((StringBuilder)object).append("No results");
                ((StringBuilder)object).append(System.getProperty("line.separator"));
                continue;
            }
            for (Object object2 : (List)hashMap.get(runtimeException)) {
                if (((Rf)object2).Le() != null) {
                    ((StringBuilder)object).append(((Rf)object2).Le());
                }
                if (((Rf)object2).eO() == null) continue;
                ((StringBuilder)object).append(((Rf)object2).eO());
            }
        }
        eO.i("%s", ((StringBuilder)object).toString());
        try {
            IO.writeFile(file, ((StringBuilder)object).toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    static {
        GlobalLog.addDestinationStream(System.out);
        eO = GlobalLog.getLogger(DecompilerExplorer.class);
        Le = new ArrayList<String>();
        Qx = null;
        lS = null;
        ae = null;
    }
}

