/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.code.asm.type.TypelibException;
import com.pnfsoftware.jeb.corei.parsers.asm.type.tlgen.OI;
import com.pnfsoftware.jeb.corei.parsers.asm.type.tlgen.TLGen;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.SerializationException;
import com.pnfsoftware.jebglobal.Wo;
import com.pnfsoftware.jebglobal.sy;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public class TypelibGen {
    private static final ILogger logger;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            String string = "JEB Type Library Generator (c) Nicolas Falliere, PNF Software\nProvide a configuration file as argument\n";
            logger.warn(string, new Object[0]);
            return;
        }
        File file = new File(stringArray[0]);
        logger.info("Configuration: %s", file);
        try {
            OI oI = OI.eO(file);
            Wo wo = new Wo(1);
            sy sy2 = sy.eO(oI.ae.getPrimaryProcessorType(), oI.ae.getPrimarySubsystemType(), oI.ae.getCompilerType());
            TLGen tLGen = new TLGen(wo, sy2, oI.Le, oI.Qx);
            tLGen.eO(oI.ae, oI.lS);
            logger.info("Success - File generated: %s", oI.lS);
            logger.info("Copy this file to your JEB's typelibs/ folder", new Object[0]);
        }
        catch (TypelibException typelibException) {
            logger.error("ERROR! %s", typelibException.getMessage());
            System.exit(-1);
        }
        catch (SerializationException serializationException) {
            logger.catching(serializationException);
        }
        catch (IOException iOException) {
            logger.catching(iOException);
        }
    }

    static {
        GlobalLog.addDestinationStream(System.out);
        try {
            String string = System.getProperty("java.io.tmpdir");
            File file = new File(string, "jeb-typelib-generator-output.log");
            GlobalLog.addDestinationStream(new PrintStream(file));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        logger = GlobalLog.getLogger(TypelibGen.class, 30);
    }
}

