/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeLibrary;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLibraryEntry;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLibraryMetadata;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.Deserializer;
import com.pnfsoftware.jeb.util.serialization.ITypeIdProvider;
import com.pnfsoftware.jeb.util.serialization.SerializationManager;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import com.pnfsoftware.jebglobal.AC;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SerDisabled
public class TypeLibraryService {
    private static final ILogger logger = GlobalLog.getLogger(TypeLibraryService.class);
    public static final int UUID_TYPELIB_WIN32_X86 = 10;
    public static final int UUID_TYPELIB_WIN32_X64 = 11;
    public static final int UUID_TYPELIB_WIN32_ARM = 12;
    public static final int UUID_TYPELIB_WIN32_ARM64 = 13;
    public static final int UUID_TYPELIB_NTDLL_X86 = 20;
    public static final int UUID_TYPELIB_NTDLL_X64 = 21;
    public static final int UUID_TYPELIB_WINDDK_X86 = 30;
    public static final int UUID_TYPELIB_WINDDK_X64 = 31;
    public static final int UUID_TYPELIB_WINDDK_ARM64 = 33;
    public static final int UUID_TYPELIB_GLIBC_X86 = 100;
    public static final int UUID_TYPELIB_GLIBC_X64 = 101;
    public static final int UUID_TYPELIB_GLIBC_ARM = 102;
    public static final int UUID_TYPELIB_GLIBC_ARM64 = 103;
    public static final int UUID_TYPELIB_GLIBC_MIPS = 104;
    public static final int UUID_TYPELIB_GLIBC_MIPS64 = 105;
    public static final int UUID_TYPELIB_ANDROID_X86 = 200;
    public static final int UUID_TYPELIB_ANDROID_X64 = 201;
    public static final int UUID_TYPELIB_ANDROID_ARM = 202;
    public static final int UUID_TYPELIB_ANDROID_ARM64 = 203;
    public static final int UUID_TYPELIB_WIN32_CONSTANTS = 1000;
    public static final int UUID_TYPELIB_WINDDK_CONSTANTS = 1001;
    public static final int UUID_TYPELIB_ANDROID_CONSTANTS = 1002;
    public static final int UUID_TYPELIB_LINUX_CONSTANTS = 1003;
    public static final int UUID_TYPELIB_TEST_X86 = 10000;
    public static final int UUID_TYPELIB_TEST_X64 = 10001;
    public static final int UUID_TYPELIB_TEST_ARM = 10002;
    public static final int UUID_TYPELIB_TEST_ARM64 = 10003;
    public static final int UUID_TYPELIB_TEST_MIPS = 10004;
    public static final int UUID_TYPELIB_TEST_MIPS64 = 10005;
    public static final int UUID_TYPELIB_TEST_X86_2 = 10010;
    public static final int GROUPID_TYPELIB_UNKNOWN = 0;
    public static final int GROUPID_TYPELIB_POSIX = 1;
    public static final int GROUPID_TYPELIB_LINUX = 2;
    public static final int GROUPID_TYPELIB_LINUX_ANDROID = 3;
    public static final int GROUPID_TYPELIB_WIN32 = 10;
    public static final int GROUPID_TYPELIB_WINDDK = 20;
    public static final int GROUPID_TYPELIB_EFI = 30;
    public static final int GROUPID_TYPELIB_TEST = 100;
    public static final int GROUPID_TYPELIB_TEST1 = 101;
    public static final int GROUPID_TYPELIB_TEST2 = 102;
    public static final int GROUPID_TYPELIB_TEST3 = 103;
    public static final int GROUPID_TYPELIB_TEST4 = 104;
    public static final String TYPELIB_FILE_EXTENSION = ".typelib";
    private List<File> folders = new ArrayList<File>();
    private List<TypeLibraryEntry> entries = new ArrayList<TypeLibraryEntry>();
    private Map<Integer, TypeLibraryEntry> idEntryMap = new HashMap<Integer, TypeLibraryEntry>();

    public TypeLibraryService() {
    }

    public TypeLibraryService(File file) {
        this.addFolder(file, true);
    }

    public synchronized void addFolder(File file, boolean bl2) {
        this.folders.add(file);
        if (bl2) {
            this.rescan();
        }
    }

    public synchronized void rescan() {
        this.rescan(true);
    }

    /*
     * Could not resolve type clashes
     */
    public synchronized void rescan(boolean bl2) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Comparable<TypeLibraryEntry> comparable : this.entries) {
            ((TypeLibraryEntry)comparable).status = 0;
        }
        for (Comparable<TypeLibraryEntry> comparable : this.folders) {
            if (comparable == null || !((File)comparable).exists() || !((File)comparable).isDirectory()) {
                logger.warn("Type library folder is invalid: %s", comparable);
                continue;
            }
            for (File file : ((File)comparable).listFiles()) {
                Object object;
                Object object2;
                if (!file.isFile() || !file.getName().endsWith(TYPELIB_FILE_EXTENSION)) continue;
                TypeLibraryMetadata typeLibraryMetadata = null;
                try {
                    object2 = new FileInputStream(file);
                    Object object3 = null;
                    try {
                        Object object4 = AC.eO();
                        object = new SerializationManager((ITypeIdProvider)object4);
                        Deserializer deserializer = ((SerializationManager)object).getDeserializer((InputStream)object2);
                        typeLibraryMetadata = (TypeLibraryMetadata)deserializer.deserialize();
                    }
                    catch (Throwable throwable) {
                        object3 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object2 != null) {
                            if (object3 != null) {
                                try {
                                    ((FileInputStream)object2).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object3).addSuppressed(throwable);
                                }
                            } else {
                                ((FileInputStream)object2).close();
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    logger.error("File %s is not a valid type library", file);
                    continue;
                }
                object2 = null;
                for (Object object4 : this.entries) {
                    if (!((TypeLibraryEntry)object4).file.equals(file)) continue;
                    object2 = object4;
                    break;
                }
                if (object2 != null && ((TypeLibraryEntry)object2).typelib != null) {
                    ((TypeLibraryEntry)object2).status = 1;
                    continue;
                }
                boolean bl3 = true;
                int n = typeLibraryMetadata.getUuid();
                if (n == 0 && (object = typeLibraryMetadata.getName()) != null) {
                    n = ((String)object).hashCode();
                }
                if (n == 0) {
                    logger.warn("Typelib entry has neither a uuid nor a name from which a uuid will be derived. It will not be loaded. Entry: %s", typeLibraryMetadata);
                    arrayList.add(file);
                    bl3 = false;
                } else {
                    object = this.idEntryMap.get(n);
                    if (object != null) {
                        int n2;
                        int n3 = ((TypeLibraryEntry)object).getMetadataHeader().getVersion();
                        if (n3 > (n2 = typeLibraryMetadata.getVersion())) {
                            arrayList.add(file);
                            bl3 = false;
                        } else if (n3 < n2) {
                            arrayList.add(((TypeLibraryEntry)object).file);
                            this.entries.remove(object);
                        } else {
                            logger.warn("Two typelib entries have the same UUID and version number: uuid=%d (files: %s and %s)", n, file, ((TypeLibraryEntry)object).file);
                        }
                    }
                }
                if (!bl3) continue;
                object2 = new TypeLibraryEntry(file, typeLibraryMetadata);
                ((TypeLibraryEntry)object2).status = 1;
                this.entries.add((TypeLibraryEntry)object2);
                this.idEntryMap.put(n, (TypeLibraryEntry)object2);
            }
        }
        if (bl2) {
            for (Comparable<TypeLibraryEntry> comparable : arrayList) {
                ((File)comparable).delete();
            }
        }
        int n = 0;
        while (n < this.entries.size()) {
            Comparable<TypeLibraryEntry> comparable;
            comparable = this.entries.get(n);
            if (((TypeLibraryEntry)comparable).status == 0) {
                if (((TypeLibraryEntry)comparable).typelib != null) {
                    ((TypeLibraryEntry)comparable).status = -1;
                } else {
                    this.entries.remove(n);
                    continue;
                }
            }
            ++n;
        }
    }

    public synchronized List<TypeLibraryEntry> getAvailables() {
        return new ArrayList<TypeLibraryEntry>(this.entries);
    }

    public synchronized List<ITypeLibrary> getLoadedTypeLibraries() {
        ArrayList<ITypeLibrary> arrayList = new ArrayList<ITypeLibrary>();
        for (TypeLibraryEntry typeLibraryEntry : this.entries) {
            if (typeLibraryEntry.typelib == null) continue;
            arrayList.add(typeLibraryEntry.typelib);
        }
        return arrayList;
    }

    public synchronized List<ITypeLibrary> getNotLoadedTypeLibraries() {
        ArrayList<ITypeLibrary> arrayList = new ArrayList<ITypeLibrary>();
        for (TypeLibraryEntry typeLibraryEntry : this.entries) {
            if (typeLibraryEntry.typelib != null) continue;
            arrayList.add(typeLibraryEntry.typelib);
        }
        return arrayList;
    }

    public synchronized boolean load(TypeLibraryEntry typeLibraryEntry) {
        if (typeLibraryEntry.typelib != null) {
            return true;
        }
        return this.loadInternal(typeLibraryEntry);
    }

    public synchronized boolean loadSingle(ProcessorType processorType, int n) {
        return this.load(processorType, n, 1);
    }

    public synchronized boolean load(ProcessorType processorType, int n) {
        return this.load(processorType, n, Integer.MAX_VALUE);
    }

    public synchronized boolean load(ProcessorType processorType, int n, int n2) {
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        ArrayList<ITypeLibrary> arrayList = new ArrayList<ITypeLibrary>();
        for (ITypeLibrary object2 : this.getLoadedTypeLibraries()) {
            if (!object2.getProcessorTypes().contains((Object)processorType) || object2.getGroupId() != n) continue;
            arrayList.add(object2);
        }
        int n3 = arrayList.size();
        if (n3 >= n2) {
            return n3 > 0;
        }
        n2 -= n3;
        ArrayList<TypeLibraryEntry> arrayList2 = new ArrayList<TypeLibraryEntry>();
        for (TypeLibraryEntry typeLibraryEntry : this.getAvailables()) {
            TypeLibraryMetadata typeLibraryMetadata = typeLibraryEntry.getMetadataHeader();
            if (typeLibraryEntry.typelib != null || typeLibraryEntry.status != 1 || !typeLibraryMetadata.getProcessorTypes().contains((Object)processorType) || typeLibraryMetadata.getGroupId() != n) continue;
            arrayList2.add(typeLibraryEntry);
        }
        Collections.sort(arrayList2, new Comparator<TypeLibraryEntry>(){

            @Override
            public int compare(TypeLibraryEntry typeLibraryEntry, TypeLibraryEntry typeLibraryEntry2) {
                return Double.compare(typeLibraryEntry.getMetadataHeader().getPriorityOrder(), typeLibraryEntry2.getMetadataHeader().getPriorityOrder());
            }
        });
        for (TypeLibraryEntry typeLibraryEntry : arrayList2) {
            logger.i(typeLibraryEntry.hdr.getName(), new Object[0]);
            if (n2 <= 0) break;
            if (!this.loadInternal(typeLibraryEntry)) continue;
            --n2;
            ++n3;
        }
        return n3 > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean loadInternal(TypeLibraryEntry typeLibraryEntry) {
        File file = typeLibraryEntry.getFile();
        logger.debug("Loading typelib: %s", file);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            ITypeLibrary iTypeLibrary;
            AC aC = AC.eO();
            SerializationManager serializationManager = new SerializationManager(aC);
            Deserializer deserializer = serializationManager.getDeserializer(fileInputStream);
            deserializer.deserialize();
            typeLibraryEntry.typelib = iTypeLibrary = (ITypeLibrary)deserializer.deserialize();
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            logger.error("File %s is not a valid type library", file);
            return false;
        }
    }

    public synchronized boolean loadExternal(ITypeLibrary iTypeLibrary) {
        for (TypeLibraryEntry typeLibraryEntry : this.entries) {
            if (typeLibraryEntry.typelib != iTypeLibrary) continue;
            typeLibraryEntry.status = 1;
            return true;
        }
        TypeLibraryEntry typeLibraryEntry = new TypeLibraryEntry(null, null);
        typeLibraryEntry.typelib = iTypeLibrary;
        typeLibraryEntry.status = 1;
        this.entries.add(typeLibraryEntry);
        return true;
    }

    public synchronized INativeMethodItem findRoutineByName(String string, ProcessorType processorType) {
        return this.findRoutineByName(string, processorType, 0);
    }

    public synchronized INativeMethodItem findRoutineByName(String string, ProcessorType processorType, int n) {
        for (ITypeLibrary iTypeLibrary : this.getLoadedTypeLibraries()) {
            if (processorType != null && !iTypeLibrary.getProcessorTypes().contains((Object)processorType) || n != 0 && n != iTypeLibrary.getGroupId()) continue;
            for (INativeMethodItem iNativeMethodItem : iTypeLibrary.getRoutines()) {
                if (!Strings.isContainedIn(string, iNativeMethodItem.getName(true), iNativeMethodItem.getName(false))) continue;
                return iNativeMethodItem;
            }
        }
        return null;
    }

    public synchronized INativeType findTypeBySignature(String string, ProcessorType processorType) {
        return this.findTypeBySignature(string, processorType, 0);
    }

    public synchronized INativeType findTypeBySignature(String string, ProcessorType processorType, int n) {
        for (ITypeLibrary iTypeLibrary : this.getLoadedTypeLibraries()) {
            if (processorType != null && !iTypeLibrary.getProcessorTypes().contains((Object)processorType) || n != 0 && n != iTypeLibrary.getGroupId()) continue;
            for (INativeType iNativeType : iTypeLibrary.getTypes()) {
                if (!Strings.isContainedIn(string, iNativeType.getSignature(true), iNativeType.getSignature(false))) continue;
                return iNativeType;
            }
        }
        return null;
    }

    public static String groupIdToName(int n) {
        switch (n) {
            case 1: {
                return "POSIX";
            }
            case 2: {
                return "Linux";
            }
            case 10: {
                return "Win32";
            }
            case 20: {
                return "WinDDK";
            }
        }
        return Integer.toString(n);
    }
}

