/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.codeobject.CompilerType;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.SubsystemType;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Ser
public class TypeLibraryMetadata {
    @SerId(value=1)
    ProcessorType primaryProcessorType;
    @SerId(value=2)
    int groupId;
    @SerId(value=3)
    int version;
    @SerId(value=4)
    String name;
    @SerId(value=5)
    String description;
    @SerId(value=6)
    String author;
    @SerId(value=7)
    long creationTimestamp;
    @SerId(value=8)
    double priorityOrder;
    @SerId(value=9)
    List<ProcessorType> addProcessorTypes;
    @SerId(value=10)
    List<SubsystemType> subsystemTypes;
    @SerId(value=11)
    CompilerType compilerType;
    @SerId(value=12)
    int uuid;

    public static TypeLibraryMetadata create(ProcessorType processorType, SubsystemType subsystemType, CompilerType compilerType, int n, double d2, int n2, int n3, String string, String string2, String string3) {
        ArrayList<ProcessorType> arrayList = new ArrayList<ProcessorType>();
        if (processorType != null) {
            arrayList.add(processorType);
        }
        ArrayList<SubsystemType> arrayList2 = new ArrayList<SubsystemType>();
        if (subsystemType != null) {
            arrayList2.add(subsystemType);
        }
        return TypeLibraryMetadata.create(arrayList, arrayList2, compilerType, n, d2, n2, n3, string, string2, string3);
    }

    public static TypeLibraryMetadata create(List<ProcessorType> list, List<SubsystemType> list2, CompilerType compilerType, int n, double d2, int n2, int n3, String string, String string2, String string3) {
        TypeLibraryMetadata typeLibraryMetadata = new TypeLibraryMetadata(list, list2, compilerType, n, d2);
        typeLibraryMetadata.uuid = n2;
        typeLibraryMetadata.version = n3;
        typeLibraryMetadata.name = string;
        typeLibraryMetadata.description = string2;
        typeLibraryMetadata.author = string3;
        typeLibraryMetadata.creationTimestamp = System.currentTimeMillis() / 1000L;
        return typeLibraryMetadata;
    }

    private TypeLibraryMetadata(List<ProcessorType> list, List<SubsystemType> list2, CompilerType compilerType, int n, double d2) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list.size() >= 1) {
            this.primaryProcessorType = list.get(0);
        }
        if (list.size() >= 2) {
            this.addProcessorTypes = new ArrayList<ProcessorType>(list.subList(1, list.size()));
        }
        if (list2 != null) {
            this.subsystemTypes = new ArrayList<SubsystemType>(list2);
        }
        this.compilerType = compilerType;
        this.groupId = n;
        this.priorityOrder = d2;
    }

    public ProcessorType getPrimaryProcessorType() {
        return this.primaryProcessorType;
    }

    public List<ProcessorType> getProcessorTypes() {
        ArrayList<ProcessorType> arrayList = new ArrayList<ProcessorType>();
        if (this.primaryProcessorType != null) {
            arrayList.add(this.primaryProcessorType);
        }
        if (this.addProcessorTypes != null) {
            arrayList.addAll(this.addProcessorTypes);
        }
        return arrayList;
    }

    public SubsystemType getPrimarySubsystemType() {
        return this.subsystemTypes == null || this.subsystemTypes.isEmpty() ? null : this.subsystemTypes.get(0);
    }

    public List<SubsystemType> getSubsystemTypes() {
        return this.subsystemTypes == null ? Collections.emptyList() : this.subsystemTypes;
    }

    public CompilerType getCompilerType() {
        return this.compilerType;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public double getPriorityOrder() {
        return this.priorityOrder;
    }

    public int getUuid() {
        return this.uuid;
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String toString() {
        return String.format("%s/%d/%f(%d/%s/%s/%s/%d)", this.getProcessorTypes(), this.groupId, this.priorityOrder, this.version, this.name, this.description, this.author, this.creationTimestamp);
    }
}

