/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class RoutineIOSlot {
    @SerId(value=1)
    Type type;
    @SerId(value=2)
    int value;
    @SerId(value=3)
    int value2;
    @SerId(value=4)
    private TransformationRule transformation;

    public static RoutineIOSlot createStackSlot(int n) {
        return new RoutineIOSlot(Type.STACK, n, -1, null);
    }

    public static RoutineIOSlot createRegister(int n) {
        if (n < 0) {
            throw new RuntimeException("Illegal register index for slot: " + n);
        }
        return new RoutineIOSlot(Type.REGISTER, n, -1, null);
    }

    public static RoutineIOSlot createRegisterPair(int n, int n2) {
        return RoutineIOSlot.createRegisterPair(n, n2, false);
    }

    public static RoutineIOSlot createRegisterPairEndianDep(int n, int n2) {
        return RoutineIOSlot.createRegisterPair(n, n2, true);
    }

    private static RoutineIOSlot createRegisterPair(int n, int n2, boolean bl2) {
        if (n < 0) {
            throw new RuntimeException("Illegal register index for first slot: " + n);
        }
        if (n2 < 0) {
            throw new RuntimeException("Illegal register index for second slot: " + n2);
        }
        return new RoutineIOSlot(Type.REGISTER_PAIR, n, n2, bl2 ? TransformationRule.ENDIAN_DEPENDENT : TransformationRule.NONE);
    }

    private RoutineIOSlot(Type type, int n, int n2, TransformationRule transformationRule) {
        if (type == null) {
            throw new NullPointerException("Missing slot type");
        }
        this.type = type;
        this.value = n;
        this.value2 = n2;
        this.transformation = transformationRule;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.type == null ? 0 : this.type.hashCode());
        n2 = 31 * n2 + this.value;
        n2 = 31 * n2 + this.value2;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RoutineIOSlot routineIOSlot = (RoutineIOSlot)object;
        if (this.type != routineIOSlot.type) {
            return false;
        }
        if (this.value != routineIOSlot.value) {
            return false;
        }
        return this.value2 == routineIOSlot.value2;
    }

    public Type getType() {
        return this.type;
    }

    public int getValue() {
        return this.value;
    }

    public int getValue(Endianness endianness) {
        if (this.transformation == TransformationRule.ENDIAN_DEPENDENT) {
            return endianness == Endianness.LITTLE_ENDIAN ? this.value : this.value2;
        }
        return this.value;
    }

    public int getValue2() {
        return this.value2;
    }

    public int getValue2(Endianness endianness) {
        if (this.transformation == TransformationRule.ENDIAN_DEPENDENT) {
            return endianness == Endianness.LITTLE_ENDIAN ? this.value2 : this.value;
        }
        return this.value2;
    }

    public String toString() {
        String string = String.format("%s[%d", new Object[]{this.getType(), this.getValue()});
        if (this.getType() == Type.REGISTER_PAIR) {
            string = string + String.format(",%d", this.getValue2());
        }
        string = string + "]";
        return string;
    }

    @Ser
    public static enum TransformationRule {
        NONE,
        ENDIAN_DEPENDENT;

    }

    @Ser
    public static enum Type {
        STACK,
        REGISTER,
        REGISTER_PAIR;

    }
}

