/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor.arch;

import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBank;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBankLayout;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterDescriptionEntry;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterType;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.Endianness;

public class RegisterUtil {
    public static String byteArrayToHexSmart(Endianness endianness, byte[] byArray) {
        return RegisterUtil.byteArrayToHexSmart(endianness, byArray, 0, byArray.length);
    }

    public static String byteArrayToHexSmart(Endianness endianness, byte[] byArray, int n, int n2) {
        if (byArray == null || n < 0 || n2 > byArray.length || n > n2) {
            throw new IllegalArgumentException();
        }
        int n3 = n2 - n;
        switch (n3) {
            case 1: {
                return String.format("0x%02X", byArray[n]);
            }
            case 2: {
                return String.format("0x%04X", EndianUtil.bytesToShort(byArray, n, endianness.toByteOrder()));
            }
            case 4: {
                return String.format("0x%08X", EndianUtil.bytesToInt(byArray, n, endianness.toByteOrder()));
            }
            case 8: {
                return String.format("0x%016X", EndianUtil.bytesToLong(byArray, n, endianness.toByteOrder()));
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int j = n; j < n2; ++j) {
            stringBuilder.append(String.format("%02X", byArray[j]));
        }
        return stringBuilder.toString();
    }

    public static RegisterDescriptionEntry getEntryByType(IRegisterBankLayout iRegisterBankLayout, RegisterType registerType) {
        for (RegisterDescriptionEntry registerDescriptionEntry : iRegisterBankLayout.getDescriptionEntries()) {
            if (registerDescriptionEntry.getType() != registerType) continue;
            return registerDescriptionEntry;
        }
        return null;
    }

    public static RegisterDescriptionEntry getEntryByType(IRegisterBank iRegisterBank, RegisterType registerType) {
        return RegisterUtil.getEntryByType(iRegisterBank.getLayout(), registerType);
    }

    public static RegisterDescriptionEntry getEntryByName(IRegisterBankLayout iRegisterBankLayout, String string) {
        for (RegisterDescriptionEntry registerDescriptionEntry : iRegisterBankLayout.getDescriptionEntries()) {
            if (!registerDescriptionEntry.getNames().contains(string)) continue;
            return registerDescriptionEntry;
        }
        return null;
    }

    public static RegisterDescriptionEntry getEntryByName(IRegisterBank iRegisterBank, String string) {
        return RegisterUtil.getEntryByName(iRegisterBank.getLayout(), string);
    }

    public static byte[] getValueByName(IRegisterBank iRegisterBank, String string) {
        RegisterDescriptionEntry registerDescriptionEntry = RegisterUtil.getEntryByName(iRegisterBank, string);
        if (registerDescriptionEntry == null) {
            return null;
        }
        return iRegisterBank.getValue(registerDescriptionEntry.getNumber());
    }

    public static Long getValueByNameAsLong(IRegisterBank iRegisterBank, String string) {
        RegisterDescriptionEntry registerDescriptionEntry = RegisterUtil.getEntryByName(iRegisterBank, string);
        if (registerDescriptionEntry == null) {
            return null;
        }
        return iRegisterBank.getValueAsLong(registerDescriptionEntry.getNumber());
    }

    public static boolean setValueByName(IRegisterBank iRegisterBank, String string, byte[] byArray) {
        RegisterDescriptionEntry registerDescriptionEntry = RegisterUtil.getEntryByName(iRegisterBank, string);
        if (registerDescriptionEntry == null) {
            return false;
        }
        return iRegisterBank.setValue(registerDescriptionEntry.getNumber(), byArray);
    }

    public static boolean setValueByNameAsLong(IRegisterBank iRegisterBank, String string, long l2) {
        RegisterDescriptionEntry registerDescriptionEntry = RegisterUtil.getEntryByName(iRegisterBank, string);
        if (registerDescriptionEntry == null) {
            return false;
        }
        return iRegisterBank.setValueAsLong(registerDescriptionEntry.getNumber(), l2);
    }
}

