/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor.arch;

import com.pnfsoftware.jeb.core.units.code.asm.processor.CannotReadRegisterException;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBank;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterDescriptionEntry;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterType;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.AbstractRegisterBankLayout;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.Endianness;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractRegisterBank
implements IRegisterBank {
    private AbstractRegisterBankLayout layout;
    private Endianness endianness;
    protected Map<Integer, byte[]> values = new HashMap<Integer, byte[]>();
    protected Set<Integer> dirtyRegisters = new TreeSet<Integer>();

    public AbstractRegisterBank(AbstractRegisterBankLayout abstractRegisterBankLayout, Endianness endianness) {
        if (abstractRegisterBankLayout == null) {
            throw new NullPointerException("Need a bank register layout");
        }
        if (endianness == null) {
            throw new NullPointerException("Need byte ordering");
        }
        this.layout = abstractRegisterBankLayout;
        this.endianness = endianness;
    }

    @Override
    public AbstractRegisterBankLayout getLayout() {
        return this.layout;
    }

    @Override
    public Endianness getEndianness() {
        return this.endianness;
    }

    Collection<RegisterDescriptionEntry> getDescriptionEntries() {
        return this.layout.getDescriptionEntries();
    }

    RegisterDescriptionEntry getDescriptionEntry(int n) {
        return this.layout.getDescriptionEntry(n);
    }

    int getCountOfDescriptionEntries() {
        return this.layout.getCountOfDescriptionEntries();
    }

    @Override
    public int size() {
        return this.getCountOfDescriptionEntries();
    }

    @Override
    public String getName(int n) {
        return this.getDescriptionEntry(n).getName();
    }

    @Override
    public int getBitsize(int n) {
        return this.getDescriptionEntry(n).getBitsize();
    }

    public int getSize(int n) {
        return this.getDescriptionEntry(n).getSize();
    }

    @Override
    public byte[] getValue(int n) {
        return this.values.get(n);
    }

    @Override
    public Long getValueAsLong(int n) {
        byte[] byArray = this.values.get(n);
        if (byArray == null) {
            return null;
        }
        RegisterDescriptionEntry registerDescriptionEntry = this.getDescriptionEntry(n);
        if (byArray.length != registerDescriptionEntry.getSize()) {
            return null;
        }
        switch (registerDescriptionEntry.getBitsize()) {
            case 8: {
                return (long)byArray[0] & 0xFFL;
            }
            case 16: {
                return (long)EndianUtil.bytesToShort(byArray, 0, this.endianness.toByteOrder()) & 0xFFFFL;
            }
            case 32: {
                return (long)EndianUtil.bytesToInt(byArray, 0, this.endianness.toByteOrder()) & 0xFFFFFFFFL;
            }
            case 64: {
                return EndianUtil.bytesToLong(byArray, 0, this.endianness.toByteOrder());
            }
        }
        return null;
    }

    @Override
    public boolean setValue(int n, byte[] byArray) {
        if (byArray != null && byArray.length != this.getSize(n)) {
            return false;
        }
        byte[] byArray2 = this.values.get(n);
        if (Arrays.equals(byArray2, byArray)) {
            return true;
        }
        this.values.put(n, byArray);
        this.dirtyRegisters.add(n);
        return true;
    }

    @Override
    public boolean setValueAsLong(int n, long l2) {
        byte[] byArray;
        block13: {
            int n2;
            block12: {
                n2 = this.getSize(n);
                byArray = new byte[n2];
                if (!this.endianness.isBig()) break block12;
                switch (n2) {
                    case 1: {
                        byArray[0] = (byte)l2;
                        break block13;
                    }
                    case 2: {
                        EndianUtil.shortToBEBytes((short)l2, byArray);
                        break block13;
                    }
                    case 4: {
                        EndianUtil.intToBEBytes((int)l2, byArray);
                        break block13;
                    }
                    case 8: {
                        EndianUtil.longToBEBytes(l2, byArray);
                        break block13;
                    }
                    default: {
                        return false;
                    }
                }
            }
            switch (n2) {
                case 1: {
                    byArray[0] = (byte)l2;
                    break;
                }
                case 2: {
                    EndianUtil.shortToLEBytes((short)l2, byArray);
                    break;
                }
                case 4: {
                    EndianUtil.intToLEBytes((int)l2, byArray);
                    break;
                }
                case 8: {
                    EndianUtil.longToLEBytes(l2, byArray);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        this.setValue(n, byArray);
        return true;
    }

    public Set<Integer> getDirtyRegisters() {
        return this.dirtyRegisters;
    }

    public boolean isDirty(int n) {
        return this.dirtyRegisters.contains(n);
    }

    public void setDirty(int n) {
        this.dirtyRegisters.add(n);
    }

    public void setAllDirty() {
        this.dirtyRegisters.addAll(this.values.keySet());
    }

    public void clearDirty(int n) {
        this.dirtyRegisters.remove(n);
    }

    public void clearAllDirty() {
        this.dirtyRegisters.clear();
    }

    @Override
    public long getProgramCounter() throws CannotReadRegisterException {
        RegisterDescriptionEntry registerDescriptionEntry = this.layout.getDescriptionEntryByType(RegisterType.ProgramCounter);
        if (registerDescriptionEntry == null) {
            throw new CannotReadRegisterException(RegisterType.ProgramCounter);
        }
        Long l2 = this.getValueAsLong(registerDescriptionEntry.getNumber());
        if (l2 == null) {
            throw new CannotReadRegisterException(RegisterType.ProgramCounter);
        }
        return l2;
    }

    @Override
    public long getFlags() throws CannotReadRegisterException {
        RegisterDescriptionEntry registerDescriptionEntry = this.layout.getDescriptionEntryByType(RegisterType.Flags);
        if (registerDescriptionEntry == null) {
            throw new CannotReadRegisterException(RegisterType.Flags);
        }
        Long l2 = this.getValueAsLong(registerDescriptionEntry.getNumber());
        if (l2 == null) {
            throw new CannotReadRegisterException(RegisterType.Flags);
        }
        return l2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (RegisterDescriptionEntry registerDescriptionEntry : this.getDescriptionEntries()) {
            byte[] byArray;
            int n2 = registerDescriptionEntry.getNumber();
            if (n > 0 && n % 4 == 0) {
                stringBuilder.append("\n");
            }
            if ((byArray = this.getValue(n2)) == null) {
                stringBuilder.append(String.format("%s:%s ", this.getName(n2), Strings.generate('?', (this.getBitsize(n2) + 3) / 4)));
            } else {
                stringBuilder.append(String.format("%s:%s ", this.getName(n2), RegisterUtil.byteArrayToHexSmart(this.endianness, byArray)));
            }
            ++n;
        }
        return stringBuilder.toString();
    }
}

