/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor;

import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterEncoding;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterType;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.List;

public class RegisterDescriptionEntry {
    private int number;
    private List<String> names = new ArrayList<String>();
    private int bitsize;
    private RegisterEncoding encoding;
    private RegisterType type;
    private int offset;

    public RegisterDescriptionEntry(int n, String string, int n2, RegisterEncoding registerEncoding, String string2, RegisterType registerType, int n3) {
        if (Strings.isBlank(string)) {
            throw new IllegalArgumentException("Register name cannot be null or empty: " + string);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Illegal register bitsize: " + n2);
        }
        this.number = n;
        this.addName(string);
        this.bitsize = n2;
        this.addName(string2);
        this.encoding = registerEncoding == null ? RegisterEncoding.unknown : registerEncoding;
        this.type = registerType == null ? RegisterType.Unspecified : registerType;
        this.offset = n3;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public String getName() {
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public RegisterDescriptionEntry addName(String string) {
        if (string != null && !Strings.isBlank(string) && !this.names.contains(string)) {
            this.names.add(string);
        }
        return this;
    }

    public int getBitsize() {
        return this.bitsize;
    }

    public int getSize() {
        return (this.bitsize + 7) / 8;
    }

    public RegisterEncoding getEncoding() {
        return this.encoding;
    }

    public RegisterType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("%d:%s(%d)", this.getNumber(), this.getName(), this.getBitsize()));
        if (this.names.size() >= 2) {
            stringBuilder.append(String.format("[%s]", Strings.join(",", this.names.subList(1, this.names.size()))));
        }
        if (this.getType() != RegisterType.Unspecified) {
            stringBuilder.append(String.format("/%s", new Object[]{this.getType()}));
        }
        if (this.getEncoding() != RegisterEncoding.unknown) {
            stringBuilder.append(String.format("/%s", new Object[]{this.getEncoding()}));
        }
        if (this.getOffset() >= 0) {
            stringBuilder.append(String.format("@%Xh", this.getOffset()));
        }
        return stringBuilder.toString();
    }
}

