/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.comp;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECompose;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECond;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEOperation;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IERange;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IESlice;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.OperationType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.comp.INode;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.comp.Leaf;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.comp.Node;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.comp.O;
import com.pnfsoftware.jebglobal.kz;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EExpressionMatcher {
    INode template;
    Map<Integer, Object> map;
    int state;

    public EExpressionMatcher(INode iNode, Map<Integer, Object> map) {
        if (iNode == null) {
            throw new IllegalArgumentException();
        }
        this.template = iNode;
        this.map = new HashMap<Integer, Object>();
        if (map != null) {
            this.map.putAll(map);
        }
    }

    public EExpressionMatcher(INode iNode) {
        this(iNode, null);
    }

    public Map<Integer, Object> getMatchMap() {
        return this.map;
    }

    public void reset() {
        this.map.clear();
        this.state = 0;
    }

    public boolean isMatch(IEGeneric iEGeneric) {
        if (this.state != 0) {
            throw new IllegalStateException();
        }
        this.state = 1;
        return this.isEqual(iEGeneric, this.template);
    }

    private boolean isEqual(IEGeneric iEGeneric, INode iNode) {
        if (iNode instanceof Node) {
            Object object;
            int n;
            Object object2;
            Object object3;
            Node node = (Node)iNode;
            Object object4 = node.operator;
            if (object4 == null) {
                if (!(iEGeneric instanceof IEOperation)) {
                    return false;
                }
                object3 = ((IEOperation)iEGeneric).getOperationType();
                object2 = node.opgrp.operators;
                int n2 = ((O[])object2).length;
                for (n = 0; n < n2; ++n) {
                    object = object2[n];
                    if (((O)((Object)object)).getOperationType() != object3) continue;
                    object4 = object;
                    int n3 = 1000 + node.opgrp.id;
                    Object object5 = this.map.get(n3);
                    if (object5 != null) {
                        if (object5 == object3) break;
                        return false;
                    }
                    this.map.put(n3, object4);
                    break;
                }
                if (object4 == null) {
                    return false;
                }
            }
            switch (object4) {
                case SLICE: {
                    if (iEGeneric instanceof IESlice) {
                        int n4 = ((Leaf)node.opnds[1]).value.intValue();
                        int n5 = ((Leaf)node.opnds[2]).value.intValue();
                        if (n4 == ((IESlice)iEGeneric).getBitStart() && n5 == ((IESlice)iEGeneric).getBitEnd()) {
                            IEGeneric iEGeneric2 = ((IESlice)iEGeneric).getWholeExpression();
                            return this.isEqual(iEGeneric2, node.opnds[0]);
                        }
                    }
                    return false;
                }
                case SLICE_FIRSTBIT: {
                    if (iEGeneric instanceof IESlice && (object3 = ((IESlice)iEGeneric).getRange()).getRangeLength() == 1 && object3.getBegin() == 0) {
                        object2 = ((IESlice)iEGeneric).getWholeExpression();
                        return this.isEqual((IEGeneric)object2, node.opnds[0]);
                    }
                    return false;
                }
                case SLICE_LASTBIT: {
                    if (iEGeneric instanceof IESlice) {
                        object3 = ((IESlice)iEGeneric).getWholeExpression();
                        object2 = ((IESlice)iEGeneric).getRange();
                        if (object2.getRangeLength() == 1 && object2.getEnd() == object3.getBitsize()) {
                            return this.isEqual((IEGeneric)object3, node.opnds[0]);
                        }
                    }
                    return false;
                }
                case SLICE_FIRST32: {
                    if (iEGeneric instanceof IESlice) {
                        object3 = ((IESlice)iEGeneric).getWholeExpression();
                        object2 = ((IESlice)iEGeneric).getRange();
                        if (object2.getRangeLength() == 32 && object2.getBegin() == 0) {
                            return this.isEqual((IEGeneric)object3, node.opnds[0]);
                        }
                    }
                    return false;
                }
                case SLICE_HALF1: {
                    if (iEGeneric instanceof IESlice) {
                        object3 = ((IESlice)iEGeneric).getWholeExpression();
                        object2 = ((IESlice)iEGeneric).getRange();
                        if (object2.getRangeLength() == object3.getBitsize() / 2 && object2.getBegin() == 0) {
                            return this.isEqual((IEGeneric)object3, node.opnds[0]);
                        }
                    }
                    return false;
                }
                case SLICE_HALF2: {
                    if (iEGeneric instanceof IESlice) {
                        object3 = ((IESlice)iEGeneric).getWholeExpression();
                        object2 = ((IESlice)iEGeneric).getRange();
                        if (object2.getRangeLength() == object3.getBitsize() / 2 && object2.getEnd() == object3.getBitsize()) {
                            return this.isEqual((IEGeneric)object3, node.opnds[0]);
                        }
                    }
                    return false;
                }
                case COMPOSE_2: {
                    if (iEGeneric instanceof IECompose && (object3 = (IECompose)iEGeneric).getPartsCount() == 2) {
                        return this.isEqual(object3.getLowPart(), node.opnds[0]) && this.isEqual(object3.getHighPart(), node.opnds[1]);
                    }
                    return false;
                }
                case COMPOSE_2EQ: {
                    if (iEGeneric instanceof IECompose && (object3 = (IECompose)iEGeneric).getPartsCount() == 2 && object3.getLowPart().getBitsize() == object3.getHighPart().getBitsize()) {
                        return this.isEqual(object3.getLowPart(), node.opnds[0]) && this.isEqual(object3.getHighPart(), node.opnds[1]);
                    }
                    return false;
                }
                case COND: {
                    if (iEGeneric instanceof IECond) {
                        object3 = (IECond)iEGeneric;
                        return this.isEqual(object3.getPredicate(), node.opnds[0]) && this.isEqual(object3.getExpressionTrue(), node.opnds[1]) && this.isEqual(object3.getExpressionFalse(), node.opnds[2]);
                    }
                    return false;
                }
            }
            if (iEGeneric instanceof IEOperation && EExpressionMatcher.compareOperator((OperationType)((Object)(object2 = (object3 = (IEOperation)iEGeneric).getOperationType())), object4)) {
                List<IEGeneric> list = EUtil.getSubExpressions((IEGeneric)object3);
                n = 0;
                if (object4.isCommutative() && node.opnds[0] instanceof Leaf && node.opnds[1] instanceof Leaf) {
                    object = (Leaf)node.opnds[0];
                    Leaf leaf = (Leaf)node.opnds[1];
                    int n6 = ((Leaf)object).id;
                    int n2 = leaf.id;
                    IEGeneric iEGeneric2 = (IEGeneric)this.map.get(n6);
                    IEGeneric iEGeneric3 = (IEGeneric)this.map.get(n2);
                    if (iEGeneric2 != null && iEGeneric3 == null) {
                        if (iEGeneric2.equals(list.get(1))) {
                            n = 1;
                        }
                    } else if (iEGeneric2 == null && iEGeneric3 != null) {
                        if (iEGeneric3.equals(list.get(0))) {
                            n = 1;
                        }
                    } else if (!(iEGeneric2 == null || iEGeneric3 == null || iEGeneric2.equals(list.get(0)) && iEGeneric3.equals(list.get(1)))) {
                        n = 1;
                    }
                }
                if (n != 0) {
                    return this.isEqual(list.get(0), node.opnds[1]) && this.isEqual(list.get(1), node.opnds[0]);
                }
                int n8 = 0;
                for (IEGeneric iEGeneric4 : list) {
                    if (!this.isEqual(iEGeneric4, node.opnds[n8])) {
                        return false;
                    }
                    ++n8;
                }
                return true;
            }
        } else {
            Leaf leaf = (Leaf)iNode;
            if (leaf.optionalBitsize != 0 && leaf.optionalBitsize != iEGeneric.getBitsize()) {
                return false;
            }
            if (iEGeneric instanceof IEVar && (leaf.flags & 2) != 0 || iEGeneric instanceof IEImm && (leaf.flags & 1) != 0 || iEGeneric instanceof IERange && (leaf.flags & 4) != 0 || (leaf.flags & 8) != 0) {
                if (leaf.handler != null && (iEGeneric = leaf.handler.process(leaf, iEGeneric)) == null) {
                    return false;
                }
                IEGeneric iEGeneric5 = (IEGeneric)this.map.get(leaf.id);
                if (iEGeneric5 != null) {
                    return this.equals(iEGeneric5, iEGeneric, leaf);
                }
                this.map.put(leaf.id, iEGeneric);
                return true;
            }
            if (iEGeneric instanceof IEImm && (leaf.flags & 0x10) != 0) {
                Object object;
                if (leaf.id >= 0) {
                    object = (IEGeneric)this.map.get(leaf.id);
                    if (object != null) {
                        return this.equals((IEGeneric)object, iEGeneric, leaf);
                    }
                    this.map.put(leaf.id, iEGeneric);
                }
                if (((BigInteger)(object = ((IEImm)iEGeneric).getValue())).compareTo(leaf.value) == 0) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean equals(IEGeneric iEGeneric, IEGeneric iEGeneric2, Leaf leaf) {
        if (iEGeneric.equals(iEGeneric2)) {
            return true;
        }
        if (iEGeneric.equalsEx(iEGeneric2, false) && iEGeneric instanceof kz && iEGeneric2 instanceof kz) {
            if (((kz)iEGeneric2).OP() == null) {
                return true;
            }
            if (((kz)iEGeneric).OP() == null) {
                this.map.put(leaf.id, iEGeneric2);
                return true;
            }
            return true;
        }
        return false;
    }

    static boolean compareOperator(OperationType operationType, O o) {
        switch (o) {
            case MUL: {
                return operationType == OperationType.MUL_U || operationType == OperationType.MUL_S;
            }
            case DIV: {
                return operationType == OperationType.DIV_U || operationType == OperationType.DIV_S;
            }
            case REM: {
                return operationType == OperationType.REM_U || operationType == OperationType.REM_S;
            }
        }
        return o.getOperationType() == operationType;
    }
}

