/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.emulator;

import com.pnfsoftware.jeb.core.AbstractEnginesPlugin;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.PointerDescription;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.emulator.EmulatorLog;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.emulator.EmulatorState;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.emulator.SimpleCEmulator;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Map;

public class MarsAnalyticaTracerPlugin
extends AbstractEnginesPlugin {
    private static final ILogger logger = GlobalLog.getLogger(MarsAnalyticaTracerPlugin.class);
    private static final int REG_RAX_ID = -65536;
    private static final int REG_RBP_ID = -65856;
    private static final int REG_RBX_ID = -65728;

    @Override
    public void load(IEnginesContext iEnginesContext) {
        logger.info("Loading MarsAnalytica tracer plugin", new Object[0]);
    }

    @Override
    public void execute(IEnginesContext iEnginesContext, Map<String, String> map) {
        logger.info("Executing MarsAnalytica tracer plugin", new Object[0]);
        IRuntimeProject iRuntimeProject = iEnginesContext.getProject(0);
        ILiveArtifact iLiveArtifact = iRuntimeProject.getLiveArtifact(0);
        IUnit iUnit = iLiveArtifact.getMainUnit();
        INativeCodeUnit iNativeCodeUnit = UnitUtil.findDescendantsByType(iUnit, INativeCodeUnit.class, false).get(0);
        logger.info("Code unit: %s", iNativeCodeUnit);
        if (!iNativeCodeUnit.process()) {
            logger.info("ERROR: Failed to process code unit", new Object[0]);
            return;
        }
        INativeDecompilerUnit iNativeDecompilerUnit = (INativeDecompilerUnit)DecompilerHelper.getDecompiler(iNativeCodeUnit);
        logger.info("Decompiler: %s", iNativeDecompilerUnit);
        EmulatorState emulatorState = new EmulatorState(iNativeCodeUnit);
        emulatorState.setRegisterValue(-65856, 14998336L);
        emulatorState.setRegisterValue(-65728, 0L);
        SimpleCEmulator simpleCEmulator = new SimpleCEmulator();
        Long l2 = 4197801L;
        ICMethod iCMethod = this.disassembleAndDecompile(iNativeDecompilerUnit, l2);
        while (true) {
            EmulatorLog emulatorLog;
            if ((l2 = (emulatorState = (emulatorLog = simpleCEmulator.emulate(iCMethod, emulatorState)).getCurrentEmulatorState()).getRegisterValue(-65536)) == null) break;
            iCMethod = this.disassembleAndDecompile(iNativeDecompilerUnit, l2);
        }
        logger.i("  >> STOP: no next entry-point address found", new Object[0]);
    }

    private ICMethod disassembleAndDecompile(INativeDecompilerUnit<?> iNativeDecompilerUnit, long l2) {
        Object object;
        if (!iNativeDecompilerUnit.getCodeUnit().getCodeModel().isRoutineHeader(l2)) {
            object = iNativeDecompilerUnit.getCodeUnit().getProcessor().createEntryPoint(l2);
            iNativeDecompilerUnit.getCodeUnit().getCodeAnalyzer().enqueuePointerForAnalysis((PointerDescription)object);
            iNativeDecompilerUnit.getCodeUnit().getCodeAnalyzer().analyze();
        }
        object = String.format("%x", l2);
        return (ICMethod)iNativeDecompilerUnit.decompile((String)object).getRootElement();
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("MarsAnalytica", "Plugin to trace MarsAnalytica execution", "Joan Calvet (PNF Software)", Version.create(1, 0, 0));
    }
}

