/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.emulator;

import com.pnfsoftware.jeb.client.HeadlessClientContext;
import com.pnfsoftware.jeb.core.Artifact;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.core.input.FileInput;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.emulator.MarsAnalyticaTracerPlugin;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;

public class HeadlessClient {
    private static final ILogger logger = GlobalLog.getLogger(HeadlessClient.class);
    private static final String targetExecutablePath = "C:\\work\\crackmes\\nsec\\MarsAnalytica";

    public static void main(String[] stringArray) throws JebException, IOException {
        HeadlessClientContext headlessClientContext = new HeadlessClientContext(){

            @Override
            public boolean isDevelopmentMode() {
                return true;
            }
        };
        headlessClientContext.initialize(stringArray);
        headlessClientContext.start();
        IEnginesContext iEnginesContext = headlessClientContext.getEnginesContext();
        iEnginesContext.getPropertyManager().setBoolean(".parsers.dcmp_x86_64.IROptimizerDisableAggressivePass", true);
        File file = new File(targetExecutablePath);
        IRuntimeProject iRuntimeProject = iEnginesContext.loadProject("ProjectTest");
        iRuntimeProject.processArtifact(new Artifact(file.getName(), new FileInput(file)));
        try {
            MarsAnalyticaTracerPlugin marsAnalyticaTracerPlugin = new MarsAnalyticaTracerPlugin();
            marsAnalyticaTracerPlugin.execute(headlessClientContext.getEnginesContext());
        }
        catch (Exception exception) {
            logger.catching(exception);
        }
        headlessClientContext.stop();
    }
}

