/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.analyzer;

import com.pnfsoftware.jeb.core.units.code.EntryPointDescription;
import com.pnfsoftware.jeb.core.units.code.IBasicBlockSkeleton;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.PointerDescription;
import com.pnfsoftware.jeb.core.units.code.asm.ChainedOperationResult;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.BinaryPatternVerifier;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IBinaryPattern;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeAnalyzer;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeAnalyzerExtension;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.SwitchInformation;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.NativeDecompilationStage;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.util.collect.ISegmentMap;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jebglobal.Xc;
import com.pnfsoftware.jebglobal.qb;
import java.util.List;

@Ser
public abstract class AbstractAnalyzerExtension<InsnType extends IInstruction>
implements INativeCodeAnalyzerExtension<InsnType> {
    @SerId(value=1)
    protected INativeCodeAnalyzer<InsnType> gca;
    @SerTransient
    protected BinaryPatternVerifier prologueVerifier;
    @SerTransient
    protected BinaryPatternVerifier paddingVerifier;

    @Override
    public void initialize(INativeCodeAnalyzer<InsnType> iNativeCodeAnalyzer) {
        if (iNativeCodeAnalyzer == null) {
            throw new NullPointerException();
        }
        if (this.gca != null && this.gca != iNativeCodeAnalyzer) {
            throw new IllegalStateException();
        }
        this.gca = iNativeCodeAnalyzer;
        this.prologueVerifier = new BinaryPatternVerifier();
        this.initializeProloguePatterns(this.prologueVerifier);
        this.paddingVerifier = new BinaryPatternVerifier();
        this.initializePaddingPatterns(this.paddingVerifier);
    }

    protected void initializeProloguePatterns(BinaryPatternVerifier binaryPatternVerifier) {
    }

    @Override
    public void typeManagerInitialized(ITypeManager iTypeManager) {
    }

    @Override
    public ChainedOperationResult<Boolean> preprocessImage(int n) {
        return ChainedOperationResult.FALSE_CONTINUE;
    }

    @Override
    public ChainedOperationResult<Boolean> postprocessImage(int n) {
        return ChainedOperationResult.FALSE_CONTINUE;
    }

    @Override
    public ChainedOperationResult<Boolean> sigMatchingPostProcess(int n) {
        return ChainedOperationResult.FALSE_CONTINUE;
    }

    @Override
    public ChainedOperationResult<EntryPointDescription> getPrologueLooking(long l2, long l3) {
        IBinaryPattern iBinaryPattern = this.checkBinaryPattern(this.prologueVerifier, l2, l3);
        if (iBinaryPattern != null) {
            return new ChainedOperationResult<EntryPointDescription>(new EntryPointDescription(l2, iBinaryPattern.getProcessorMode()));
        }
        return ChainedOperationResult.ignore();
    }

    protected void initializePaddingPatterns(BinaryPatternVerifier binaryPatternVerifier) {
    }

    @Override
    public ChainedOperationResult<Long> getPossiblePaddingSize(long l2, long l3) {
        long l4;
        qb qb2;
        IBinaryPattern iBinaryPattern = this.checkBinaryPattern(this.paddingVerifier, l2, l3);
        if (iBinaryPattern == null) {
            return ChainedOperationResult.ZEROL_CONTINUE;
        }
        ISegmentMap<Long, qb> iSegmentMap = ((Xc)this.gca).Le();
        boolean bl2 = false;
        if (iSegmentMap != null && (qb2 = iSegmentMap.getSegmentContaining(l2)) != null && (l4 = qb2.eO()) != 0L && l4 != 1L) {
            bl2 = true;
            if (l2 % l4 != 0L) {
                return new ChainedOperationResult<Long>((long)iBinaryPattern.getBinary().length & 0xFFFFFFFFL);
            }
        }
        if (!bl2) {
            return new ChainedOperationResult<Long>((long)iBinaryPattern.getBinary().length & 0xFFFFFFFFL);
        }
        return ChainedOperationResult.ZEROL_CONTINUE;
    }

    @Override
    public ChainedOperationResult<List<EntryPointDescription>> getProbableEntryPoints(long l2, long l3) {
        return ChainedOperationResult.ignore();
    }

    protected IBinaryPattern checkBinaryPattern(BinaryPatternVerifier binaryPatternVerifier, long l2, long l3) {
        int n = Math.min(binaryPatternVerifier.getLongestSize(), (int)(l3 - l2));
        byte[] byArray = new byte[n];
        if (!VirtualMemoryUtil.readSafe(this.gca.getMemory(), l2, byArray)) {
            return null;
        }
        return binaryPatternVerifier.verify(this.gca, l2, byArray, 0, byArray.length);
    }

    @Override
    public ChainedOperationResult<? extends PointerDescription> isTrampolineToDynResRoutine(CFG<InsnType> cFG) {
        return ChainedOperationResult.continue_();
    }

    @Override
    public ChainedOperationResult<Integer> determineRoutineStackPointerDelta(CFG<InsnType> cFG) {
        return ChainedOperationResult.continue_();
    }

    @Override
    public ChainedOperationResult<Boolean> determinePotentialPointers(long l2, InsnType InsnType, List<PointerDescription> list) {
        return ChainedOperationResult.FALSE_CONTINUE;
    }

    @Override
    public ChainedOperationResult<Boolean> shouldForceRoutineEnd(long l2, InsnType InsnType) {
        return ChainedOperationResult.FALSE_CONTINUE;
    }

    @Override
    public ChainedOperationResult<Boolean> isNonReturningRoutine(INativeMethodItem iNativeMethodItem) {
        return ChainedOperationResult.ignore();
    }

    @Override
    public ChainedOperationResult<Boolean> isCandidateSwitchDispatcher(long l2, InsnType InsnType, List<InsnType> list) {
        return ChainedOperationResult.FALSE_CONTINUE;
    }

    @Override
    public ChainedOperationResult<SwitchInformation> determineSwitchInformation(long l2, IBasicBlockSkeleton<InsnType> iBasicBlockSkeleton, List<IBasicBlockSkeleton<InsnType>> list) {
        return ChainedOperationResult.continue_();
    }

    @Override
    public ChainedOperationResult<NativeDecompilationStage> getPreferredAdvancedAnalysisStage(INativeMethodItem iNativeMethodItem) {
        return new ChainedOperationResult<NativeDecompilationStage>(NativeDecompilationStage.SIMULATION_COMPLETED, ChainedOperationResult.ContinuationStatus.CONTINUE);
    }
}

