/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android;

import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.ParametersInfo;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexDebugInfo;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexField;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexFieldData;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethodData;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexType;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexValue;
import com.pnfsoftware.jeb.corei.parsers.dex.of;
import com.pnfsoftware.jeb.corei.parsers.dex.wk;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DexUtil {
    private static final ILogger logger = GlobalLog.getLogger(DexUtil.class);

    private DexUtil() {
    }

    public static final int getVersion(IBinaryUnit iBinaryUnit) throws ParseException {
        ByteBuffer byteBuffer = iBinaryUnit.getInput().getHeader();
        byte[] byArray = new byte[3];
        byteBuffer.position(4);
        byteBuffer.get(byArray);
        if (!(Character.isDigit(byArray[0]) && Character.isDigit(byArray[1]) && Character.isDigit(byArray[2]))) {
            throw new ParseException("Illegal version number", 0);
        }
        String string = Strings.decodeASCII(byArray);
        string = Strings.ltrim(string, '0');
        return Conversion.stringToInt(string);
    }

    private static void illegalEncoding(String string, byte[] byArray, int n) {
        int n2;
        if (string == null) {
            string = "Illegal DEX encoding";
        }
        if ((n2 = byArray.length - n) < 0) {
            throw new of(String.format("%s: error, nothing to decode", string));
        }
        int n3 = Math.min(n2, 16);
        throw new of(String.format("%s: %s", string, Formatter.formatBinaryLine(byArray, n, n3, 0)));
    }

    public static int bytearrayULEInt16ToInt(byte[] byArray, int n) {
        if (n + 2 > byArray.length) {
            DexUtil.illegalEncoding("INT16: not enough data", byArray, n);
        }
        int n2 = byArray[n] & 0xFF;
        return n2 |= (byArray[n + 1] & 0xFF) << 8;
    }

    public static int bytearrayULEInt32ToInt(byte[] byArray, int n) {
        if (n + 4 > byArray.length) {
            DexUtil.illegalEncoding("INT32: not enough data", byArray, n);
        }
        int n2 = byArray[n] & 0xFF;
        n2 |= (byArray[n + 1] & 0xFF) << 8;
        n2 |= (byArray[n + 2] & 0xFF) << 16;
        if ((n2 |= (byArray[n + 3] & 0xFF) << 24) < -1) {
            DexUtil.illegalEncoding("INT32: resulting in -1", byArray, n);
        }
        return n2;
    }

    public static int bytearraySLEB128ToInt(byte[] byArray, int n, int[] nArray) {
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        while (n3 < 0) {
            if (n + n4 >= byArray.length) {
                DexUtil.illegalEncoding("LEB128: not enough data", byArray, n);
            }
            n3 = byArray[n + n4];
            n2 |= (n3 & 0x7F) << n4 * 7;
            ++n4;
        }
        if (n4 > 5) {
            DexUtil.illegalEncoding("LEB128: too long", byArray, n);
        }
        if ((n3 & 0x40) != 0) {
            if (n4 == 1) {
                n2 |= 0xFFFFFF80;
            }
            if (n4 == 2) {
                n2 |= 0xFFFFC000;
            }
            if (n4 == 3) {
                n2 |= 0xFFE00000;
            }
            if (n4 == 4) {
                n2 |= 0xF0000000;
            }
        }
        nArray[0] = n4;
        return n2;
    }

    public static int bytearrayULEB128ToInt(byte[] byArray, int n, int[] nArray) {
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        while (n3 < 0) {
            if (n + n4 >= byArray.length) {
                DexUtil.illegalEncoding("ULEB128: not enough data", byArray, n);
            }
            n3 = byArray[n + n4];
            n2 |= (n3 & 0x7F) << n4 * 7;
            ++n4;
        }
        if (n4 > 5) {
            DexUtil.illegalEncoding("ULEB128: too long", byArray, n);
        }
        nArray[0] = n4;
        return n2;
    }

    public static int bytearrayULEB128P1ToInt(byte[] byArray, int n, int[] nArray) {
        int n2 = DexUtil.bytearrayULEB128ToInt(byArray, n, nArray);
        return n2 - 1;
    }

    public static String bytearrayMUTF8ToStringFast(byte[] byArray, int n, int[] nArray, int n2) {
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = n;
        while (true) {
            if (n4 >= byArray.length) {
                DexUtil.illegalEncoding("MUTF8: not enough data at offset " + n4, byArray, n);
            }
            int n5 = byArray[n4] & 0xFF;
            ++n4;
            if (n5 == 0) break;
            if (n3 >= n2) {
                DexUtil.illegalEncoding("MUTF8: string is longer than expected: " + n2, byArray, n);
            }
            if ((n5 & 0x80) != 0) {
                int n6;
                if ((n5 & 0xE0) == 192) {
                    if (n4 >= byArray.length) {
                        DexUtil.illegalEncoding("MUTF8: 2be: not enough data at offset " + n4, byArray, n);
                    }
                    n6 = byArray[n4] & 0xFF;
                    ++n4;
                    if ((n6 & 0xC0) == 128) {
                        n5 = (n5 & 0x1F) << 6 | n6 & 0x3F;
                    } else {
                        DexUtil.illegalEncoding("MUTF8: Invalid 2-byte encoding at offset " + n4, byArray, n);
                    }
                } else if ((n5 & 0xF0) == 224) {
                    if (n4 + 2 > byArray.length) {
                        DexUtil.illegalEncoding("MUTF8: 3be: not enough data at offset " + n4, byArray, n);
                    }
                    n6 = byArray[n4] & 0xFF;
                    int n7 = byArray[++n4] & 0xFF;
                    ++n4;
                    if ((n6 & 0xC0) == 128 && (n7 & 0xC0) == 128) {
                        n5 = (n5 & 0xF) << 12 | (n6 & 0x3F) << 6 | n7 & 0x3F;
                    } else {
                        DexUtil.illegalEncoding("MUTF8: Invalid 3-byte encoding at offset " + n4, byArray, n);
                    }
                } else {
                    DexUtil.illegalEncoding("MUTF8: Invalid encoding at offset " + n4, byArray, n);
                }
            }
            cArray[n3++] = (char)n5;
        }
        if (nArray != null) {
            nArray[0] = n4 - n;
        }
        return new String(cArray);
    }

    public static String bytearrayMUTF8ToString(byte[] byArray, int n, int[] nArray) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n;
        int n4 = 0;
        while (true) {
            int n5;
            if (n3 >= byArray.length) {
                DexUtil.illegalEncoding("MUTF8: not enough data at offset " + n3, byArray, n);
            }
            n2 = byArray[n3] & 0xFF;
            ++n3;
            if (n2 == 0) break;
            if ((n2 & 0x80) != 0) {
                if ((n2 & 0xE0) == 192) {
                    if (n3 >= byArray.length) {
                        DexUtil.illegalEncoding("MUTF8: 2be: not enough data at offset " + n3, byArray, n);
                    }
                    n5 = byArray[n3] & 0xFF;
                    ++n3;
                    if ((n5 & 0xC0) == 128) {
                        n2 = (n2 & 0x1F) << 6 | n5 & 0x3F;
                    } else {
                        DexUtil.illegalEncoding("MUTF8: Invalid 2-byte encoding at offset " + n3, byArray, n);
                    }
                } else if ((n2 & 0xF0) == 224) {
                    if (n3 + 2 > byArray.length) {
                        DexUtil.illegalEncoding("MUTF8: 3be: not enough data at offset " + n3, byArray, n);
                    }
                    n5 = byArray[n3] & 0xFF;
                    int n6 = byArray[++n3] & 0xFF;
                    ++n3;
                    if ((n5 & 0xC0) == 128 && (n6 & 0xC0) == 128) {
                        if ((n2 = (n2 & 0xF) << 12 | (n5 & 0x3F) << 6 | n6 & 0x3F) >= 55296 && n2 <= 56319) {
                            if (n4 != 0) {
                                logger.i("MUTF8: Expecting second surrogate element", new Object[0]);
                                int n7 = (n4 - 65536 >> 10) + 55296;
                                stringBuilder.appendCodePoint(n7);
                            }
                            n4 = 65536 + (n2 - 55296 << 10);
                            continue;
                        }
                        if (n2 >= 56320 && n2 <= 57343) {
                            if (n4 == 0) {
                                logger.i("MUTF8: First surrogate element is missing (x = 0x%X)", n2);
                            } else {
                                n2 = n4 + (n2 - 56320);
                                n4 = 0;
                            }
                        }
                    } else {
                        DexUtil.illegalEncoding("MUTF8: Invalid 3-byte encoding at offset " + n3, byArray, n);
                    }
                } else {
                    DexUtil.illegalEncoding("MUTF8: Invalid encoding at offset " + n3, byArray, n);
                }
            }
            if (n4 != 0) {
                logger.i("MUTF8: Null terminator found, second surrogate element was expected", new Object[0]);
                n5 = (n4 - 65536 >> 10) + 55296;
                n4 = 0;
                stringBuilder.appendCodePoint(n5);
            }
            stringBuilder.appendCodePoint(n2);
        }
        if (n4 != 0) {
            n2 = (n4 - 65536 >> 10) + 55296;
            stringBuilder.appendCodePoint(n2);
        }
        if (nArray != null) {
            nArray[0] = n3 - n;
        }
        return stringBuilder.toString();
    }

    public static int convertDexFlagsToCodeFlags(int n) {
        int n2 = 0;
        n2 |= DexUtil.cvt(n, 1, 1);
        n2 |= DexUtil.cvt(n, 2, 2);
        n2 |= DexUtil.cvt(n, 4, 4);
        n2 |= DexUtil.cvt(n, 8, 8);
        n2 |= DexUtil.cvt(n, 16, 16);
        n2 |= DexUtil.cvt(n, 32, 32);
        n2 |= DexUtil.cvt(n, 64, 64);
        n2 |= DexUtil.cvt(n, 64, 64);
        n2 |= DexUtil.cvt(n, 128, 128);
        n2 |= DexUtil.cvt(n, 128, 128);
        n2 |= DexUtil.cvt(n, 256, 256);
        n2 |= DexUtil.cvt(n, 512, 512);
        n2 |= DexUtil.cvt(n, 1024, 1024);
        n2 |= DexUtil.cvt(n, 2048, 2048);
        n2 |= DexUtil.cvt(n, 4096, 4096);
        n2 |= DexUtil.cvt(n, 8192, 8192);
        n2 |= DexUtil.cvt(n, 16384, 16384);
        n2 |= DexUtil.cvt(n, 65536, 65536);
        return n2 |= DexUtil.cvt(n, 131072, 131072);
    }

    private static int cvt(int n, int n2, int n3) {
        if ((n & n2) != 0) {
            return n3;
        }
        return 0;
    }

    public static void validateFlags(int n) {
        if ((n & 0xFFFC8000) != 0) {
            throw new of("Invalid access flags: " + n);
        }
    }

    public static void validateClassFlags(int n) {
        if ((n & 0xFFFF89E0) != 0) {
            throw new of("Invalid class access flags: " + n);
        }
    }

    public static void validateFieldFlags(int n) {
        if ((n & 0xFFFFAF20) != 0) {
            throw new of("Invalid field access flags: " + n);
        }
    }

    public static void validateMethodFlags(int n) {
        if ((n & 0xFFFCE200) != 0) {
            throw new of("Invalid method access flags: " + n);
        }
    }

    public static String formatAccessFlags(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        DexUtil.appendAccessFlagString(stringBuilder, n, 1, "public");
        DexUtil.appendAccessFlagString(stringBuilder, n, 2, "private");
        DexUtil.appendAccessFlagString(stringBuilder, n, 4, "protected");
        DexUtil.appendAccessFlagString(stringBuilder, n, 8, "static");
        DexUtil.appendAccessFlagString(stringBuilder, n, 16, "final");
        DexUtil.appendAccessFlagString(stringBuilder, n, 1024, "abstract");
        DexUtil.appendAccessFlagString(stringBuilder, n, 512, "interface");
        DexUtil.appendAccessFlagString(stringBuilder, n, 16384, "enum");
        DexUtil.appendAccessFlagString(stringBuilder, n, 32, "synchronized");
        DexUtil.appendAccessFlagString(stringBuilder, n, 64, "volatile");
        DexUtil.appendAccessFlagString(stringBuilder, n, 64, "bridge");
        DexUtil.appendAccessFlagString(stringBuilder, n, 128, "transient");
        DexUtil.appendAccessFlagString(stringBuilder, n, 128, "varargs");
        DexUtil.appendAccessFlagString(stringBuilder, n, 256, "native");
        DexUtil.appendAccessFlagString(stringBuilder, n, 2048, "strictfp");
        DexUtil.appendAccessFlagString(stringBuilder, n, 4096, "synthetic");
        DexUtil.appendAccessFlagString(stringBuilder, n, 8192, "annotation");
        DexUtil.appendAccessFlagString(stringBuilder, n, 65536, "constructor");
        DexUtil.appendAccessFlagString(stringBuilder, n, 131072, "declared-synchronized");
        if (n2 == 1 || n2 == -1 && stringBuilder.length() > 0) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private static void appendAccessFlagString(StringBuilder stringBuilder, int n, int n2, String string) {
        if (string != null && string.length() > 0 && (n & n2) != 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
        }
    }

    public static int determineBestBase(long l2) {
        if (-20L <= l2 && l2 <= 20L) {
            return 10;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        long l3 = l2;
        int n = 0;
        int n2 = 0;
        while (l3 != 0L && l3 != -1L) {
            long l4 = l3 % 10L;
            if (l4 == 0L) {
                ++n2;
            }
            l3 /= 10L;
            ++n;
        }
        l3 = l2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (l3 != 0L && l3 != -1L) {
            long l5 = l3 & 0xFL;
            if (l5 == 0L) {
                ++n4;
            } else if (l5 == 15L) {
                ++n5;
            }
            l3 >>= 4;
            ++n3;
        }
        int n6 = n2 - (n - n2);
        int n7 = n4 + n5 - (n3 - n4 - n5);
        int n8 = n6 >= n7 ? 10 : 16;
        return n8;
    }

    public static final String formatTypenames(IDexUnit iDexUnit, Collection<Integer> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int n2 : collection) {
            if (n >= 1) {
                stringBuilder.append("\n");
            }
            IDexType iDexType = iDexUnit.getType(n2);
            stringBuilder.append(String.format("%d: %s", n2, iDexType == null ? "???" : iDexType.getName(false)));
            ++n;
        }
        return stringBuilder.toString();
    }

    public static final String formatFieldsigs(IDexUnit iDexUnit, Collection<Integer> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int n2 : collection) {
            if (n >= 1) {
                stringBuilder.append("\n");
            }
            IDexField iDexField = iDexUnit.getField(n2);
            stringBuilder.append(String.format("%d: %s", n2, iDexField == null ? "???" : iDexField.getSignature(false)));
            ++n;
        }
        return stringBuilder.toString();
    }

    public static final String formatMethodsigs(IDexUnit iDexUnit, Collection<Integer> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int n2 : collection) {
            if (n >= 1) {
                stringBuilder.append("\n");
            }
            IDexMethod iDexMethod = iDexUnit.getMethod(n2);
            stringBuilder.append(String.format("%d: %s", n2, iDexMethod == null ? "???" : iDexMethod.getSignature(false)));
            ++n;
        }
        return stringBuilder.toString();
    }

    public static IDexValue getStaticFieldInitializer(IDexClass iDexClass, IDexFieldData iDexFieldData) {
        int n = iDexClass.getData().getStaticFields().indexOf(iDexFieldData);
        if (n < 0 || n >= iDexClass.getStaticInitializers().size()) {
            return null;
        }
        return iDexClass.getStaticInitializers().get(n);
    }

    public static String[] toJniName(String string) {
        String[] stringArray = string.split("->");
        if (stringArray.length != 2) {
            return null;
        }
        String string2 = stringArray[0];
        if (string2.charAt(0) != 'L' || string2.charAt(string2.length() - 1) != ';') {
            return null;
        }
        string2 = string2.substring(1, string2.length() - 1).replace("_", "_1").replace('/', '_');
        int n = stringArray[1].indexOf(40);
        if (n < 0) {
            String string3 = stringArray[1].replace("_", "_1");
            return new String[]{"Java_" + string2 + "_" + string3};
        }
        String string4 = stringArray[1].substring(0, n).replace("_", "_1");
        String string5 = stringArray[1].substring(n);
        string5 = string5.substring(1, string5.indexOf(41)).replace("_", "_1").replace(";", "_2").replace('/', '_');
        String string6 = "Java_" + string2 + "_" + string4;
        return new String[]{string6, string6 + "__" + string5};
    }

    public static List<String> getDebugParameterNames(IDexUnit iDexUnit, IDexMethodData iDexMethodData) {
        if (iDexMethodData.getCodeItem() == null || iDexMethodData.getCodeItem().getDebugInfo() == null) {
            return null;
        }
        IDexDebugInfo iDexDebugInfo = iDexMethodData.getCodeItem().getDebugInfo();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int n : iDexDebugInfo.getParameterNameIndexes()) {
            String string = null;
            if (n >= 0 && n < iDexUnit.getStringCount()) {
                string = iDexUnit.getString(n).getValue();
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public static ParametersInfo getMethodParametersInfo(IDexUnit iDexUnit, IDexMethodData iDexMethodData) {
        boolean bl2 = (iDexMethodData.getAccessFlags() & 8) != 0;
        int n = iDexMethodData.getMethodIndex();
        int n2 = iDexUnit.getMethod(n).getPrototypeIndex();
        String string = iDexUnit.getPrototype(n2).getShorty();
        return DexUtil.getMethodParametersInfo(string, bl2);
    }

    public static ParametersInfo getMethodParametersInfo(String string, boolean bl2) {
        int n = bl2 ? 0 : 1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        block4: for (int j = 1; j < string.length(); ++j) {
            arrayList.add(n);
            char c = string.charAt(j);
            switch (c) {
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'L': 
                case 'S': 
                case 'Z': {
                    ++n;
                    continue block4;
                }
                case 'D': 
                case 'J': {
                    n += 2;
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Unknown shorty character type: " + c);
                }
            }
        }
        return new ParametersInfo(n, arrayList);
    }

    public static int getMethodSlotCount(String string, boolean bl2) {
        int n = bl2 ? 0 : 1;
        block4: for (int j = 1; j < string.length(); ++j) {
            switch (string.charAt(j)) {
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'L': 
                case 'S': 
                case 'Z': {
                    ++n;
                    continue block4;
                }
                case 'D': 
                case 'J': {
                    n += 2;
                    continue block4;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        return n;
    }

    public static boolean isSubtypeOf(IDexUnit iDexUnit, int n, int n2) {
        return ((wk)iDexUnit).OP().eO(n, n2);
    }
}

