/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android;

import com.pnfsoftware.jeb.core.units.code.android.APKSigSchemeV2Block;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import java.nio.ByteBuffer;

@Ser
public class APKSigSchemeV3Block
extends APKSigSchemeV2Block {
    private static final ILogger logger = GlobalLog.getLogger(APKSigSchemeV3Block.class);
    public static final int PROOF_OF_ROTATION_ATTR_ID = 1000370060;

    public APKSigSchemeV3Block(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    @Override
    protected void parse(int n) {
        int n2 = this.readSize();
        n -= 4 + n2;
        while (n2 > 0) {
            int n3;
            byte[] byArray;
            int n4;
            int n5;
            int n6;
            int n7;
            APKSigSchemeV2Block.Signer signer = new APKSigSchemeV2Block.Signer();
            int n8 = this.readSize();
            n2 -= 4 + n8;
            int n9 = this.readSize();
            n8 -= 4 + n9;
            int n10 = this.readSize();
            n9 -= 4 + n10;
            while (n10 > 0) {
                n7 = this.readSize();
                n10 -= 4 + n7;
                n6 = this.readInt();
                n7 -= 4;
                n5 = this.readSize();
                byte[] byArray2 = this.readBytes(n5);
                signer.digests.add(new APKSigSchemeV2Block.Digest(n6, byArray2));
                this.verifyZero(n7 -= 4 + n5);
            }
            this.verifyZero(n10);
            n9 -= 4 + n7;
            for (n7 = this.readSize(); n7 > 0; n7 -= 4 + n6) {
                n6 = this.readSize();
                byte[] byArray3 = this.readBytes(n6);
                signer.certificates.add(new APKSigSchemeV2Block.Certificate(byArray3));
            }
            this.verifyZero(n7);
            this.readInt();
            this.readInt();
            n9 -= 8;
            n9 -= 4 + n6;
            for (n6 = this.readSize(); n6 > 0; n6 -= 4 + n4) {
                n4 = this.readSize();
                int n11 = this.readInt();
                byArray = this.readBytes(n4 - 4);
                signer.attributes.add(new APKSigSchemeV2Block.Attribute(n11, byArray));
                if (n11 != 1000370060) continue;
                logger.i("[APK Sig v3] Not parsing proof of rotation info", new Object[0]);
            }
            this.verifyZero(n6);
            this.skipAndWarnIfNonZero(n9);
            this.readInt();
            this.readInt();
            n8 -= 8;
            n8 -= 4 + n5;
            for (n5 = this.readSize(); n5 > 0; n5 -= n3) {
                n3 = this.readSize();
                n5 -= 4;
                int n12 = this.readInt();
                byte[] byArray4 = this.readBytes(n3 - 4);
                signer.signatures.add(new APKSigSchemeV2Block.Signature(n12, byArray4));
            }
            this.verifyZero(n5);
            int n13 = this.readSize();
            byArray = this.readBytes(n13);
            signer.publicKey = new APKSigSchemeV2Block.PublicKey(byArray);
            this.signers.add(signer);
            this.verifyZero(n8 -= 4 + n13);
        }
        this.verifyZero(n2);
        this.verifyZero(n);
    }
}

