/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.core.units.code.IEntryPointDescription;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.List;

@Ser
public class FlowInformation
implements IFlowInformation {
    public static final FlowInformation NONE = new FlowInformation(true);
    @SerId(value=1)
    private List<IEntryPointDescription> targets;
    @SerId(value=2)
    private boolean computeFallThrough;
    @SerId(value=3)
    private int delaySlotCount;

    private FlowInformation(boolean bl2) {
        if (!bl2) {
            this.targets = new ArrayList<IEntryPointDescription>();
        }
    }

    public FlowInformation() {
        this(false);
    }

    public FlowInformation(boolean bl2, int n) {
        this(false);
        this.setComputeFallThrough(bl2);
        this.setDelaySlotCount(n);
    }

    public void addTarget(IEntryPointDescription iEntryPointDescription) {
        if (this.targets == null) {
            throw new IllegalArgumentException("NONE flow information can not contain targets");
        }
        this.targets.add(iEntryPointDescription);
    }

    @Override
    public boolean isBroken() {
        return this.targets != null;
    }

    @Override
    public boolean isBrokenUnknown() {
        return this.targets != null && (this.targets.isEmpty() || this.areAllTargetsUnknown());
    }

    @Override
    public boolean isBrokenKnown() {
        return this.targets != null && !this.targets.isEmpty() && !this.hasUnknownTargets();
    }

    private boolean hasUnknownTargets() {
        for (IEntryPointDescription iEntryPointDescription : this.targets) {
            if (!iEntryPointDescription.isUnknownAddress()) continue;
            return true;
        }
        return false;
    }

    private boolean areAllTargetsUnknown() {
        for (IEntryPointDescription iEntryPointDescription : this.targets) {
            if (iEntryPointDescription.isUnknownAddress()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<IEntryPointDescription> getTargets() {
        return this.targets;
    }

    public void setComputeFallThrough(boolean bl2) {
        this.computeFallThrough = bl2;
    }

    @Override
    public boolean mustComputeFallThrough() {
        return this.computeFallThrough;
    }

    public void setDelaySlotCount(int n) {
        if (n < 0) {
            throw new RuntimeException("Delay Slot must be a positive integer");
        }
        this.delaySlotCount = n;
    }

    @Override
    public int getDelaySlotCount() {
        return this.delaySlotCount;
    }

    public String toString() {
        return super.toString();
    }

    public static boolean isAddressInTargets(IFlowInformation iFlowInformation, long l2) {
        for (IEntryPointDescription iEntryPointDescription : iFlowInformation.getTargets()) {
            if (iEntryPointDescription.getAddress() != l2) continue;
            return true;
        }
        return false;
    }
}

