/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.tree.impl;

import com.pnfsoftware.jeb.core.output.tree.INode;
import com.pnfsoftware.jeb.core.output.tree.impl.AbstractTreeDocument;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Ser
public class StaticTreeDocument
extends AbstractTreeDocument {
    @SerId(value=1)
    private List<? extends INode> roots;
    @SerId(value=2)
    private List<String> columnLabels;
    @SerId(value=3)
    private int initialExpansionLevel;

    public StaticTreeDocument(INode iNode) {
        this(Arrays.asList(iNode));
    }

    public StaticTreeDocument(List<? extends INode> list) {
        this(list, null, 0);
    }

    public StaticTreeDocument(List<? extends INode> list, List<String> list2, int n) {
        if (list == null) {
            throw new IllegalArgumentException("Tree root should not be null");
        }
        for (INode iNode : list) {
            if (iNode != null) continue;
            throw new IllegalArgumentException("Tree root should not be null");
        }
        this.roots = new ArrayList<INode>(list);
        this.columnLabels = list2 == null ? new ArrayList<String>() : new ArrayList<String>(list2);
        this.initialExpansionLevel = n;
    }

    @Override
    public List<? extends INode> getRoots() {
        return this.roots;
    }

    @Override
    public List<String> getColumnLabels() {
        return this.columnLabels;
    }

    @Override
    public int getInitialExpansionLevel() {
        return this.initialExpansionLevel;
    }
}

