/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.tree;

import com.pnfsoftware.jeb.core.output.tree.ICodeNode;
import com.pnfsoftware.jeb.core.units.code.ICodeClass;
import com.pnfsoftware.jeb.core.units.code.ICodeField;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.ICodeMethod;
import com.pnfsoftware.jeb.core.units.code.ICodePackage;
import com.pnfsoftware.jeb.core.units.code.ICodeType;
import java.util.ArrayList;
import java.util.List;

public class CodeNodeUtil {
    public static final int IS_ARTIFICIAL = 16;
    public static final int IS_INTERNAL = 256;
    public static final int IS_PACKAGE = 32768;
    public static final int IS_TYPE = 65536;
    public static final int IS_CLASS = 131072;
    public static final int IS_FIELD = 262144;
    public static final int IS_METHOD = 524288;

    public static boolean meetsConditions(ICodeNode iCodeNode, int n, int n2) {
        ICodeItem iCodeItem = iCodeNode.getObject();
        int n3 = 0;
        if (iCodeItem instanceof ICodePackage) {
            n3 |= 0x8000;
        }
        if (iCodeItem instanceof ICodeType) {
            n3 |= 0x10000;
        }
        if (iCodeItem instanceof ICodeClass) {
            n3 |= 0x20000;
        }
        if (iCodeItem instanceof ICodeField) {
            n3 |= 0x40000;
        }
        if (iCodeItem instanceof ICodeMethod) {
            n3 |= 0x80000;
        }
        if ((iCodeItem.getGenericFlags() & Integer.MIN_VALUE) != 0) {
            n3 |= 0x100;
        }
        if ((iCodeItem.getGenericFlags() & 0x40000000) != 0) {
            n3 |= 0x10;
        }
        return (n3 & n) == n && (n3 & n2) == 0;
    }

    public static boolean mustBe(ICodeNode iCodeNode, int n) {
        return CodeNodeUtil.meetsConditions(iCodeNode, n, 0);
    }

    public static boolean cannotBe(ICodeNode iCodeNode, int n) {
        return CodeNodeUtil.meetsConditions(iCodeNode, 0, n);
    }

    public static List<? extends ICodeNode> getChildren(ICodeNode iCodeNode, int n, int n2) {
        ArrayList<ICodeNode> arrayList = new ArrayList<ICodeNode>();
        ArrayList<? extends ICodeNode> arrayList2 = new ArrayList<ICodeNode>(iCodeNode.getChildren());
        for (ICodeNode iCodeNode2 : arrayList2) {
            if (!CodeNodeUtil.meetsConditions(iCodeNode2, n, n2)) continue;
            arrayList.add(iCodeNode2);
        }
        return arrayList;
    }
}

