/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.text.impl;

import com.pnfsoftware.jeb.core.exceptions.NotImplementedException;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.CoordinatesConversionPrecision;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.TextDocumentUtil;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.util.events.EventSource;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import java.util.ArrayList;
import java.util.List;

@Ser
public abstract class AbstractTextDocument
extends EventSource
implements ITextDocument {
    @Override
    public void dispose() {
    }

    @Override
    public IPropertyManager getPropertyManager() {
        return null;
    }

    @Override
    public long getInitialAnchor() {
        return this.getFirstAnchor();
    }

    @Override
    public long getFirstAnchor() {
        return 0L;
    }

    @Override
    public ITextDocumentPart getDocumentPart(long l2, int n) {
        return this.getDocumentPart(l2, n, 0);
    }

    @Override
    public ITextDocumentPart getDocumentPart2(long l2, long l3) throws NotImplementedException {
        throw new NotImplementedException("getDocumentPart2() is not implemented in this document object: " + this.getClass().getSimpleName());
    }

    @Override
    public final String coordinatesToAddress(ICoordinates iCoordinates) {
        return this.coordinatesToAddress(iCoordinates, AddressConversionPrecision.DEFAULT);
    }

    @Override
    public String coordinatesToAddress(ICoordinates iCoordinates, AddressConversionPrecision addressConversionPrecision) {
        if (iCoordinates == null) {
            return null;
        }
        return String.format("%d,%d,%d", iCoordinates.getAnchorId(), iCoordinates.getLineDelta(), iCoordinates.getColumnOffset());
    }

    @Override
    public ICoordinates addressToCoordinates(String string) {
        return this.addressToCoordinates(string, null);
    }

    @Override
    public ICoordinates addressToCoordinates(String string, CoordinatesConversionPrecision coordinatesConversionPrecision) {
        if (coordinatesConversionPrecision == null) {
            coordinatesConversionPrecision = CoordinatesConversionPrecision.FIRST;
        }
        if (string == null || coordinatesConversionPrecision != CoordinatesConversionPrecision.FIRST) {
            return null;
        }
        List<Integer> list = AbstractTextDocument.parseIntegerList(string);
        if (list.size() == 1) {
            return new Coordinates(list.get(0).intValue());
        }
        if (list.size() == 2) {
            return new Coordinates(list.get(0).intValue(), list.get(1));
        }
        if (list.size() == 3) {
            return new Coordinates(list.get(0).intValue(), list.get(1), list.get(2));
        }
        return null;
    }

    static List<Integer> parseIntegerList(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string2 : string.split(",")) {
            try {
                int n = Integer.parseInt(string2.trim());
                arrayList.add(n);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return arrayList;
    }

    public String toString() {
        return super.toString();
    }

    @Override
    public String format() {
        return TextDocumentUtil.getText(this);
    }
}

