/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output;

import com.pnfsoftware.jeb.core.output.IUnitDocumentPresentation;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Ser
public class UnitFormatterAdapter
implements IUnitFormatter {
    private static final ILogger logger = GlobalLog.getLogger(UnitFormatterAdapter.class);
    @SerId(value=1)
    private List<IUnitDocumentPresentation> persistedPres = new ArrayList<IUnitDocumentPresentation>();
    @SerTransient
    private List<IUnitDocumentPresentation> transientPres = new ArrayList<IUnitDocumentPresentation>();
    @SerTransient
    private List<IUnitDocumentPresentation> allPres = new ArrayList<IUnitDocumentPresentation>();
    @SerTransient
    private boolean disposed;

    @SerCustomInitPostGraph
    private void init() {
        this.transientPres = new ArrayList<IUnitDocumentPresentation>();
        this.allPres = new ArrayList<IUnitDocumentPresentation>(this.persistedPres);
    }

    public UnitFormatterAdapter() {
    }

    public UnitFormatterAdapter(IUnitDocumentPresentation iUnitDocumentPresentation) {
        this.addDocumentPresentation(iUnitDocumentPresentation);
    }

    public void addDocumentPresentation(IUnitDocumentPresentation iUnitDocumentPresentation) {
        this.addPresentation(iUnitDocumentPresentation, false);
    }

    @Override
    public int getPresentationCount() {
        return this.allPres.size();
    }

    @Override
    public IUnitDocumentPresentation getPresentation(int n) {
        IUnitDocumentPresentation iUnitDocumentPresentation = this.allPres.get(n);
        if (iUnitDocumentPresentation == null) {
            throw new RuntimeException();
        }
        return iUnitDocumentPresentation;
    }

    @Override
    public void addPresentation(IUnitDocumentPresentation iUnitDocumentPresentation, boolean bl2) {
        this.insertPresentation(this.allPres.size(), iUnitDocumentPresentation, bl2);
    }

    @Override
    public void insertPresentation(int n, IUnitDocumentPresentation iUnitDocumentPresentation, boolean bl2) {
        if (this.allPres.contains(iUnitDocumentPresentation)) {
            logger.warn("This presentation is already present in the formatter", new Object[0]);
            return;
        }
        long l2 = iUnitDocumentPresentation.getId();
        for (IUnitDocumentPresentation iUnitDocumentPresentation2 : this.allPres) {
            if (iUnitDocumentPresentation2.getId() != l2) continue;
            throw new IllegalArgumentException(String.format("The presentation that is being inserted has ID %d, which is already used by another presentation in this formatter (%s)", l2, iUnitDocumentPresentation2));
        }
        List<IUnitDocumentPresentation> list = bl2 ? this.persistedPres : this.transientPres;
        int n2 = 0;
        for (int j = n - 1; j >= 0; --j) {
            IUnitDocumentPresentation iUnitDocumentPresentation3 = this.allPres.get(j);
            int n3 = list.indexOf(iUnitDocumentPresentation3);
            if (n3 < 0) continue;
            n2 = n3 + 1;
            break;
        }
        list.add(n2, iUnitDocumentPresentation);
        this.allPres.add(n, iUnitDocumentPresentation);
    }

    @Override
    public void removePresentation(int n) {
        IUnitDocumentPresentation iUnitDocumentPresentation = this.getPresentation(n);
        if (this.persistedPres.contains(iUnitDocumentPresentation)) {
            this.persistedPres.remove(iUnitDocumentPresentation);
        } else if (this.transientPres.contains(iUnitDocumentPresentation)) {
            this.transientPres.remove(iUnitDocumentPresentation);
        } else {
            throw new RuntimeException();
        }
        this.allPres.remove(n);
    }

    @Override
    public boolean isPersisted(int n) {
        IUnitDocumentPresentation iUnitDocumentPresentation = this.getPresentation(n);
        return this.persistedPres.contains(iUnitDocumentPresentation);
    }

    @Override
    public List<IUnitDocumentPresentation> getPresentations() {
        return Collections.unmodifiableList(this.allPres);
    }

    @Override
    public List<IUnitDocumentPresentation> getDocumentPresentations() {
        return this.getPresentations();
    }

    @Override
    public void discardTransientPresentations() {
        if (!this.disposed) {
            for (IUnitDocumentPresentation iUnitDocumentPresentation : this.transientPres) {
                iUnitDocumentPresentation.dispose();
            }
        }
        this.disposed = true;
    }
}

