/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.actions;

import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;

public class ActionContext {
    IInteractiveUnit unit;
    int actionId;
    long itemId;
    String address;
    AddressConversionPrecision addressPrecision;

    public ActionContext(IInteractiveUnit iInteractiveUnit, int n, long l2) {
        this(iInteractiveUnit, n, l2, null, AddressConversionPrecision.DEFAULT);
    }

    public ActionContext(IInteractiveUnit iInteractiveUnit, int n, long l2, String string) {
        this(iInteractiveUnit, n, l2, string, AddressConversionPrecision.DEFAULT);
    }

    public ActionContext(IInteractiveUnit iInteractiveUnit, int n, long l2, String string, AddressConversionPrecision addressConversionPrecision) {
        if (iInteractiveUnit == null || n == 0) {
            throw new IllegalArgumentException();
        }
        this.unit = iInteractiveUnit;
        this.actionId = n;
        this.itemId = l2;
        this.address = string;
        this.addressPrecision = addressConversionPrecision;
    }

    public IInteractiveUnit getUnit() {
        return this.unit;
    }

    public int getActionId() {
        return this.actionId;
    }

    public long getItemId() {
        return this.itemId;
    }

    public String getAddress() {
        return this.address;
    }

    public AddressConversionPrecision getAddressPrecision() {
        return this.addressPrecision;
    }

    public String toString() {
        return String.format("unit=%s,actionId=%s,itemId=%d,address=%s", this.unit, this.actionId, this.itemId, this.address);
    }
}

