/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.telemetry;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.telemetry.ITelemetryEndpoint;
import com.pnfsoftware.jeb.client.telemetry.TelemetryRecord;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.net.INet;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class StandardTelemetryEndpoint
implements ITelemetryEndpoint {
    private static final ILogger logger = GlobalLog.getLogger(StandardTelemetryEndpoint.class);
    private static final int maxRecordsPerRequest = 200;
    private long uuid;
    private INet net;
    private boolean allLooksGood;

    public StandardTelemetryEndpoint(INet iNet, long l2) {
        this.net = iNet;
        this.uuid = l2;
    }

    @Override
    public boolean canDump() {
        if (this.allLooksGood) {
            return true;
        }
        try {
            this.net.query("https://www.pnfsoftware.com/ping");
            this.allLooksGood = true;
            return true;
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            this.allLooksGood = false;
            return false;
        }
    }

    @Override
    public boolean dump(List<TelemetryRecord> list) {
        if (list.isEmpty()) {
            return true;
        }
        try {
            for (int j = 0; j < list.size(); j += 200) {
                if (j > 0) {
                    Thread.sleep(5000L);
                }
                try {
                    String string = String.format("%s/telemetry/record?product=jeb&licenseid=%d&uuid=%d", "https://www.pnfsoftware.com", Licensing.license_id, this.uuid);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    int n = Math.min(list.size(), j + 200);
                    hashMap.put("records", Strings.encodeList(list.subList(j, n)));
                    String string2 = this.net.post(string, null, hashMap);
                    logger.i("Response: %s", string2);
                    continue;
                }
                catch (IOException iOException) {
                    logger.catchingSilent(iOException);
                    this.allLooksGood = false;
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            logger.catchingSilent(exception);
            return false;
        }
    }
}

