/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.telemetry;

import com.pnfsoftware.jeb.client.AbstractContext;
import com.pnfsoftware.jeb.client.telemetry.ITelemetryDatabase;
import com.pnfsoftware.jeb.client.telemetry.ITelemetryEndpoint;
import com.pnfsoftware.jeb.client.telemetry.TelemetryException;
import com.pnfsoftware.jeb.client.telemetry.TelemetryRecord;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.Ls;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

public class StandardTelemetryDatabase
implements ITelemetryDatabase {
    private static final ILogger logger = GlobalLog.getLogger(StandardTelemetryDatabase.class);
    private static final String version = AbstractContext.app_ver.toString();
    private static final String jtdMarker = "JTD1";
    private static final String properMarker = Ls.eO(new byte[]{-125, 2, 29, 37, 29, 17, 69, 70, 9, 29, 31, 12, 21, 84, 19, 51}, 1, 208);
    private static final int defaultDumpPeriodSeconds = 300;
    private static final int defaultPurgeThreshold = 100000;
    private ITelemetryEndpoint endpoint;
    private File dbfile;
    private Connection connection = null;
    private Thread threadDumper;
    private volatile int dumpPeriodSeconds = 300;
    private volatile int purgeThreshold = 100000;
    private int errcnt;

    public StandardTelemetryDatabase(String string, ITelemetryEndpoint iTelemetryEndpoint) throws IOException, TelemetryException {
        this(string, iTelemetryEndpoint, false);
    }

    public StandardTelemetryDatabase(String string, ITelemetryEndpoint iTelemetryEndpoint, boolean bl2) throws IOException, TelemetryException {
        Object object;
        Throwable throwable;
        AutoCloseable autoCloseable;
        boolean bl3;
        if (iTelemetryEndpoint == null) {
            throw new IllegalArgumentException("Specify an endpoint");
        }
        this.endpoint = iTelemetryEndpoint;
        string = new File(string).getCanonicalPath().replace('\\', '/');
        this.dbfile = new File(string);
        boolean bl4 = bl3 = !this.dbfile.exists() || this.dbfile.length() == 0L;
        if (!bl3) {
            try {
                autoCloseable = new RandomAccessFile(this.dbfile, "rw");
                throwable = null;
                try {
                    object = new byte[16];
                    ((RandomAccessFile)autoCloseable).seek(0L);
                    ((RandomAccessFile)autoCloseable).readFully((byte[])object);
                    if (Strings.decodeASCII(object).startsWith(jtdMarker)) {
                        if ((long)(16 + EndianUtil.bytesToInt(object, 4, ByteOrder.BIG_ENDIAN)) != this.dbfile.length()) {
                            throw new IOException("Unexpected size");
                        }
                        ((RandomAccessFile)autoCloseable).seek(0L);
                        ((RandomAccessFile)autoCloseable).write(Strings.encodeASCII(properMarker));
                        ((RandomAccessFile)autoCloseable).close();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (autoCloseable != null) {
                        if (throwable != null) {
                            try {
                                ((RandomAccessFile)autoCloseable).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((RandomAccessFile)autoCloseable).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new TelemetryException(iOException);
            }
        }
        try {
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + string);
        }
        catch (SQLException sQLException) {
            throw new TelemetryException(sQLException);
        }
        if (bl3) {
            try {
                autoCloseable = this.connection.createStatement();
                throwable = null;
                try {
                    object = Ls.eO(new byte[]{115, 17, 23, 4, 21, 17, 101, 116, 21, 3, 14, 9, 101, 69, 19, 19, 11, 26, 7, 83, 8, 92, 29, 4, 8, 22, 7, 21, 12, 29, 80, 73, 7, 26, 88, 12, 86, 19, 23, 1, 26, 6, 1, 78, 84, 17, 29, 12, 88, 12, 69, 19, 19, 11, 26, 26, 15, 12, 8, 69, 84, 17, 29, 12, 88, 12, 80, 2, 29, 31, 21, 23, 6, 29, 12, 22, 83, 84, 17, 29, 12, 93}, 1, 48);
                    autoCloseable.executeUpdate((String)object);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (autoCloseable != null) {
                        if (throwable != null) {
                            try {
                                autoCloseable.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            autoCloseable.close();
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                throw new TelemetryException(sQLException);
            }
        }
        if (bl2) {
            this.startDumperThread();
        }
    }

    public void startDumperThread() {
        if (this.threadDumper != null) {
            throw new IllegalStateException();
        }
        this.threadDumper = ThreadUtil.start(new Runnable(){

            @Override
            public void run() {
                int n = 10 + new Random().nextInt(11);
                try {
                    Thread.sleep((long)n * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                if (StandardTelemetryDatabase.this.connection == null) {
                    return;
                }
                try {
                    StandardTelemetryDatabase.this.dump();
                }
                catch (Exception exception) {
                    logger.catchingSilent(exception);
                }
                while (true) {
                    try {
                        Thread.sleep((long)StandardTelemetryDatabase.this.dumpPeriodSeconds * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    if (StandardTelemetryDatabase.this.connection == null) break;
                    try {
                        StandardTelemetryDatabase.this.dump();
                    }
                    catch (Exception exception) {
                        logger.catchingSilent(exception);
                    }
                }
            }
        });
    }

    protected void finalize() throws Throwable {
        if (this.connection != null) {
            try {
                this.close();
            }
            catch (Exception exception) {
                logger.catchingSilent(exception);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void close() throws TelemetryException {
        if (this.connection == null) {
            throw new IllegalStateException("Already closed.");
        }
        if (this.errcnt > 0) {
            this.dbfile.delete();
        }
        try {
            this.connection.close();
            return;
        }
        catch (SQLException sQLException) {
            throw new TelemetryException(sQLException);
        }
        finally {
            this.connection = null;
            if (this.errcnt == 0) {
                int n = (int)this.dbfile.length();
                try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.dbfile, "rw");){
                    byte[] byArray = new byte[16];
                    randomAccessFile.seek(0L);
                    randomAccessFile.readFully(byArray);
                    if (Arrays.equals(byArray, Strings.encodeASCII(properMarker))) {
                        randomAccessFile.seek(0L);
                        randomAccessFile.write(Strings.encodeASCII(jtdMarker));
                        randomAccessFile.writeInt(n - 16);
                        randomAccessFile.writeInt(0);
                        randomAccessFile.writeInt(0);
                        randomAccessFile.close();
                    }
                }
                catch (IOException iOException) {
                    throw new TelemetryException(iOException);
                }
            }
        }
    }

    public void setDumpPeriod(int n) {
        if (n <= 0) {
            n = 300;
        }
        this.dumpPeriodSeconds = n;
    }

    public int getDumpPeriod() {
        return this.dumpPeriodSeconds;
    }

    public void setPurgeThreshold(int n) {
        if (n <= 0) {
            n = 100000;
        }
        this.purgeThreshold = n;
    }

    public int getPurgeThreshold() {
        return this.purgeThreshold;
    }

    @Override
    public boolean record(String string) {
        return this.record(string, null);
    }

    @Override
    public boolean record(String string, String string2, String string3) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put(string2, string3);
        return this.record(string, linkedHashMap);
    }

    @Override
    public boolean record(String string, String string2, String string3, String string4, String string5) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put(string2, string3);
        linkedHashMap.put(string4, string5);
        return this.record(string, linkedHashMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean record(String string, Map<String, String> map) {
        int n = (int)(System.currentTimeMillis() / 1000L);
        try (Statement statement = this.connection.createStatement();){
            String string2;
            String string3;
            if (map == null || map.isEmpty()) {
                string3 = Ls.eO(new byte[]{-44, 7, 29, 22, 23, 6, 116, 105, 7, 26, 27, 111, 69, 19, 19, 11, 26, 7, 91, 92, 29, 4, 8, 22, 7, 21, 12, 29, 92, 12, 86, 19, 23, 1, 26, 6, 1, 66, 12, 69, 19, 19, 11, 26, 26, 15, 12, 8, 76, 9, 118, 23, 13, 25, 16, 22, 123, 13, 65, 72, 12, 7, 2, 86, 84, 11, 12, 7, 2, 86, 84, 14}, 1, 157);
                string2 = String.format(string3, n, version, string);
            } else {
                string3 = Strings.encodeMap(map);
                String string4 = Ls.eO("INSERT INTO events(timestamp, version, eventname, properties) VALUES(%d, '%s', '%s', '%s')");
                string2 = String.format(string4, n, version, string, string3);
            }
            statement.executeUpdate(string2);
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            ++this.errcnt;
            logger.catchingSilent(exception);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized int size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean clear() {
        try (Statement statement = this.connection.createStatement();){
            statement.execute(Ls.eO(new byte[]{-86, 1, 9, 9, 17, 17, 101, 102, 20, 29, 2, 109, 69, 19, 19, 11, 26, 7}, 1, 238));
            boolean bl2 = true;
            return bl2;
        }
        catch (SQLException sQLException) {
            ++this.errcnt;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean dump() {
        if (!this.endpoint.canDump()) {
            return false;
        }
        StandardTelemetryDatabase standardTelemetryDatabase = this;
        synchronized (standardTelemetryDatabase) {
            ArrayList<TelemetryRecord> arrayList;
            block38: {
                try (Statement statement = this.connection.createStatement();){
                    int n;
                    Throwable throwable;
                    ResultSet resultSet;
                    block37: {
                        resultSet = statement.executeQuery(Ls.eO(new byte[]{-10, 22, 9, 9, 6, 23, 116, 10, 10, 102, 20, 29, 2, 109, 69, 19, 19, 11, 26, 7}, 1, 165));
                        throwable = null;
                        try {
                            arrayList = new ArrayList<TelemetryRecord>();
                            while (resultSet.next()) {
                                logger.i("Event: %s", resultSet.getString("eventname"));
                                n = resultSet.getInt("timestamp");
                                String string = resultSet.getString("version");
                                String string2 = resultSet.getString("eventname");
                                Map<String, String> map = Strings.decodeMap(resultSet.getString("properties"));
                                arrayList.add(new TelemetryRecord(n, string, string2, map));
                            }
                            if (arrayList.isEmpty()) {
                                n = 1;
                                break block37;
                            }
                            statement.execute(Ls.eO(new byte[]{7, 42, 60, 60, 38, 44, 71, 46, 38, 111, 101, 67, 76, 86, 84, 87, 77, 64}, 2, 112));
                            break block38;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    return n != 0;
                    finally {
                        if (resultSet != null) {
                            if (throwable != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                resultSet.close();
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    ++this.errcnt;
                    logger.catchingSilent(sQLException);
                    return false;
                }
            }
            return this.endpoint.dump(arrayList);
        }
    }
}

