/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.script;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.api.IClientContext;
import com.pnfsoftware.jeb.client.api.IScript;
import com.pnfsoftware.jeb.client.script.JythonDynamicWrapper;
import com.pnfsoftware.jeb.client.script.PythonScriptFactory;
import com.pnfsoftware.jeb.client.script.ScriptException;
import com.pnfsoftware.jeb.client.script.ScriptExecutionException;
import com.pnfsoftware.jeb.client.script.ScriptPreparationException;
import com.pnfsoftware.jeb.client.script.ScriptType;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;

public class ScriptLoader {
    private static final ILogger logger = GlobalLog.getLogger(ScriptLoader.class);
    private static JythonDynamicWrapper j;
    private ScriptType scripttype;
    private IScript script;
    private File libdir;

    public ScriptLoader(String string, String string2) throws ScriptException {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        this.libdir = new File(string2);
        if (!this.libdir.exists()) {
            if (!this.libdir.mkdir()) {
                throw new ScriptPreparationException(String.format("Cannot create directory \"%s\"", string2));
            }
        } else if (!this.libdir.isDirectory()) {
            throw new ScriptPreparationException(String.format("Path \"%s\" is not a directory", string2));
        }
        this.load(string);
    }

    public ScriptType getScriptType() {
        return this.scripttype;
    }

    private void load(String string) throws ScriptException {
        String string2;
        String string3;
        File file = new File(string);
        if (!file.exists() && !(file = new File(this.libdir, string)).exists()) {
            throw new ScriptPreparationException(S.s(706));
        }
        String string4 = file.getName();
        if (string4.endsWith(".py")) {
            string3 = string4.substring(0, string4.length() - 3);
            string2 = string3;
            if (string2.length() >= 1) {
                char c;
                int n;
                int n2;
                for (n2 = 0; n2 < string2.length() && ((n = string2.charAt(n2)) == 45 || n == 95 || Character.isDigit((char)n)); ++n2) {
                }
                for (n = string2.length() - 1; n >= 0 && ((c = string2.charAt(n)) == '-' || c == '_' || Character.isDigit(c)); --n) {
                }
                string2 = string2.substring(n2, n + '\u0001');
            }
            if (string2.isEmpty()) {
                throw new ScriptPreparationException("Illegal script name");
            }
        } else {
            throw new ScriptPreparationException("Unsupported script extension");
        }
        this.loadPython(file, string3, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPython(File file, String string, String string2) throws ScriptException {
        this.initJython();
        try (PythonScriptFactory pythonScriptFactory = null;){
            pythonScriptFactory = new PythonScriptFactory(j, file.getAbsoluteFile().getParent(), string, string2);
            this.script = pythonScriptFactory.create();
        }
        this.scripttype = ScriptType.PYTHON;
    }

    private void initJython() throws ScriptException {
        if (j != null) {
            return;
        }
        String string = null;
        for (String string2 : this.libdir.list()) {
            if (!string2.startsWith("jython") || !string2.toLowerCase().endsWith(".jar")) continue;
            string = new File(this.libdir, string2).getAbsolutePath();
            break;
        }
        if (string == null) {
            throw new ScriptPreparationException("Jython is required to run client scripts, refer to SCRIPTS.TXT for setup instructions");
        }
        logger.debug("Found Jython package: %s", string);
        try {
            j = new JythonDynamicWrapper(new File(string));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ScriptPreparationException("Invalid Jython package", reflectiveOperationException);
        }
        logger.debug("Jython was initialized successfully", new Object[0]);
    }

    public void execute(IClientContext iClientContext) throws ScriptException {
        try {
            this.script.run(iClientContext);
        }
        catch (Exception exception) {
            if (j.isPyException(exception)) {
                throw new ScriptExecutionException(exception);
            }
            throw new ScriptException(exception);
        }
    }
}

