/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.script;

import com.pnfsoftware.jeb.client.api.IClientContext;
import com.pnfsoftware.jeb.client.script.JythonDynamicWrapper;
import com.pnfsoftware.jeb.client.script.JythonUtil;
import com.pnfsoftware.jeb.client.script.LogRedirectionOutputStream;
import com.pnfsoftware.jeb.client.script.ScriptExecutionException;
import com.pnfsoftware.jeb.client.script.TypeInfo;
import com.pnfsoftware.jeb.client.script.TypeInfoProvider;
import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.interpreter.AutocompletionResult;
import com.pnfsoftware.jeb.util.interpreter.ExecutionResult;
import com.pnfsoftware.jeb.util.interpreter.ICommandInterpreter;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class PythonInterpreter
implements ICommandInterpreter {
    private static final ILogger logger = GlobalLog.getLogger(PythonInterpreter.class);
    private static JythonDynamicWrapper j;
    private File jythonJar;
    private File scriptsDir;
    private IClientContext ctx;
    private boolean allowAutoImport;
    private TypeInfoProvider typeinfoprv;
    private int status;
    private Object interpreter;
    private LogRedirectionOutputStream out;
    private LogRedirectionOutputStream err;

    public PythonInterpreter(File file, File file2, IClientContext iClientContext) throws JebException {
        if (file == null && file2 == null) {
            throw new IllegalArgumentException();
        }
        if (file == null) {
            file = JythonUtil.findJythonJar(file2);
        }
        if (file2 == null) {
            file2 = file.getParentFile();
        }
        this.jythonJar = file;
        this.scriptsDir = file2;
        this.ctx = iClientContext;
        if (j != null) {
            if (!j.getJythonJarFile().equals(file)) {
                throw new JebException(String.format("jython.jar is already loaded from %s, it cannot be reloaded from %s", j.getJythonJarFile(), file));
            }
        } else {
            try {
                j = new JythonDynamicWrapper(file);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
        }
    }

    public void setAllowAutoImport(boolean bl2) {
        this.allowAutoImport = bl2;
    }

    public boolean isAllowAutoImport() {
        return this.allowAutoImport;
    }

    public void setTypeInfoProvider(TypeInfoProvider typeInfoProvider) {
        this.typeinfoprv = typeInfoProvider;
    }

    public TypeInfoProvider getTypeInfoProvider() {
        return this.typeinfoprv;
    }

    @Override
    public void prepare() {
        if (this.status != 0) {
            return;
        }
        this.status = -1;
        try {
            Properties properties = new Properties();
            properties.put("python.home", this.jythonJar.getParent());
            properties.put("python.console.encoding", "UTF-8");
            properties.put("python.security.respectJavaAccessibility", "false");
            Properties properties2 = System.getProperties();
            j.PythonInterpreter_initialize(properties2, properties, new String[0]);
            long l2 = System.currentTimeMillis();
            this.interpreter = j.PythonInterpreter_init(null, j.PySystemState_init());
            logger.i("Jython interpreter init time: %dms", System.currentTimeMillis() - l2);
            j.PythonInterpreter_exec(this.interpreter, "import sys");
            if (this.scriptsDir != null) {
                j.PythonInterpreter_exec(this.interpreter, String.format("sys.path.append(\"%s\")", this.scriptsDir.getAbsolutePath().replace("\\", "\\\\")));
            }
            this.out = new LogRedirectionOutputStream(30, true);
            j.PythonInterpreter_setOut(this.interpreter, this.out);
            this.err = new LogRedirectionOutputStream(50, false);
            j.PythonInterpreter_setErr(this.interpreter, this.err);
            Reader reader = new Reader(){

                @Override
                public int read(char[] cArray, int n, int n2) throws IOException {
                    logger.error("This interpreter does not accept input from stdin at the moment", new Object[0]);
                    return -1;
                }

                @Override
                public void close() throws IOException {
                }
            };
            j.PythonInterpreter_setIn(this.interpreter, reader);
            if (this.ctx != null) {
                j.PythonInterpreter_set(this.interpreter, "jeb", this.ctx);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getTargetException());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
        this.status = 1;
    }

    public void injectObject(String string, Object object) throws ScriptExecutionException {
        try {
            j.PythonInterpreter_set(this.interpreter, string, object);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ScriptExecutionException(invocationTargetException.getTargetException());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    @Override
    public ExecutionResult executeCommand(String string) {
        return this.executeInternal(string, this.isAllowAutoImport());
    }

    public ExecutionResult executeInternal(String string, boolean bl2) {
        Object object;
        if ("help".equals(string.trim())) {
            String string2 = "";
            string2 = string2 + String.format("JEB Developers Portal: %s", "https://www.pnfsoftware.com/jeb/devportal");
            string2 = string2 + String.format("\nAPI Reference Documention: %s ", "https://www.pnfsoftware.com/jeb/apidoc");
            string2 = string2 + String.format("\nSample Scripts: %s", "https://github.com/pnfsoftware/jeb2-samplecode/tree/master/scripts");
            return ExecutionResult.success(string2);
        }
        try {
            this.prepare();
        }
        catch (Exception exception) {
            return ExecutionResult.error(exception);
        }
        int n = bl2 ? 0 : -1;
        Object object2 = null;
        while (true) {
            try {
                object = j.PythonInterpreter_compile(this.interpreter, string);
                object2 = j.PythonInterpreter_eval(this.interpreter, object);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string3;
                block18: {
                    string3 = invocationTargetException.getCause().toString();
                    if (n == 0 && j.isPyException(invocationTargetException.getCause())) {
                        try {
                            Couple<Object, Object> couple = j.getPyExceptionTypeAndValue(invocationTargetException.getCause());
                            logger.i("%s", couple);
                            String string4 = couple.getSecond().toString();
                            String string5 = this.getUndefinedName(string4);
                            if (string5 != null) {
                                logger.i("%s", string5);
                                TypeInfo typeInfo = this.findCandidateJebApiType(string5);
                                if (typeInfo != null) {
                                    if (!typeInfo.getSimpleName().equals(string5)) {
                                        string3 = string3 + "# Did you mean " + typeInfo.getSimpleName() + "?";
                                    } else if (this.loadJebApiType(typeInfo.getName())) {
                                        logger.debug("# Auto-imported %s", typeInfo.getName());
                                        n = 1;
                                        continue;
                                    }
                                }
                            }
                            break block18;
                        }
                        catch (Exception exception) {
                            // empty catch block
                            break block18;
                        }
                        continue;
                    }
                }
                return ExecutionResult.error(string3);
            }
            catch (Exception exception) {
                return ExecutionResult.error(exception);
            }
            break;
        }
        if (object2 != null && !j.isPyNone(object2)) {
            object = object2.toString();
            if (j.isPyString(object2)) {
                object = "'" + (String)object + "'";
            }
        } else {
            object = this.out.pullCurrent();
        }
        return ExecutionResult.success((String)object);
    }

    @Override
    public String getName() {
        return "py";
    }

    @Override
    public String getDescription() {
        return String.format("Python Interpreter (uses %s)", this.jythonJar);
    }

    @Override
    public String getBanner() {
        String string = "";
        string = string + "* JEB Python interpreter (EXPERIMENTAL) - uses " + this.jythonJar + "\n";
        string = string + "* The current client context (type: com.pnfsoftware.jeb.client.api.IClientContext) is located in the `jeb` global variable\n";
        if (this.scriptsDir != null) {
            string = string + "* The following folder was auto-added to sys.path: " + this.scriptsDir + "\n";
        }
        string = string + "* Refer to the API doc (Help menu) and sample scripts and plugins to get started";
        return string;
    }

    @Override
    public boolean shouldDisplayRawResults() {
        return true;
    }

    @Override
    public AutocompletionResult autoComplete(String string) {
        try {
            this.prepare();
        }
        catch (Exception exception) {
            return AutocompletionResult.EMPTY;
        }
        if (string == null) {
            return AutocompletionResult.EMPTY;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return AutocompletionResult.EMPTY;
        }
        String string2 = string.substring(n + 1);
        String string3 = string.substring(0, n);
        if ((n = string3.lastIndexOf(46)) >= 0) {
            string3 = string3.substring(n + 1);
        }
        if ((n = string3.lastIndexOf(32)) >= 0) {
            string3 = string3.substring(n + 1);
        }
        if ((n = string3.lastIndexOf(9)) >= 0) {
            string3 = string3.substring(n + 1);
        }
        if (string3.isEmpty()) {
            return AutocompletionResult.EMPTY;
        }
        try {
            Object object = j.PythonInterpreter_get(this.interpreter, string3);
            if (object != null && (object = j.PyObject_tojava(object, Object.class)) != null) {
                AutocompletionResult autocompletionResult = new AutocompletionResult(null, '.');
                HashSet hashSet = new HashSet();
                hashSet.add(Object.class);
                this.recordCandidates(object.getClass(), string2, autocompletionResult, hashSet);
                return autocompletionResult;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return AutocompletionResult.EMPTY;
    }

    private void recordCandidates(Class<?> clazz, String string, AutocompletionResult autocompletionResult, Set<Class<?>> set) {
        Object object;
        if (!set.add(clazz)) {
            return;
        }
        if (!this.isJebPrivateType(clazz)) {
            object = clazz.getDeclaredMethods();
            int n = ((Method[])object).length;
            for (int j = 0; j < n; ++j) {
                Method method = object[j];
                if ((method.getModifiers() & 1) == 0) continue;
                this.attemptRecordName(method.getName(), string, autocompletionResult);
            }
        }
        if ((object = clazz.getSuperclass()) == null) {
            return;
        }
        this.recordCandidates((Class<?>)object, string, autocompletionResult, set);
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.recordCandidates(clazz2, string, autocompletionResult, set);
        }
    }

    private boolean isJebPrivateType(Class<?> clazz) {
        String string = clazz.getName();
        if (string.startsWith("com.pnfsoftware.jeb.clienti")) {
            return true;
        }
        if (string.startsWith("com.pnfsoftware.jeb.corei")) {
            return true;
        }
        return string.startsWith("com.pnfsoftware.jeb.rcpclient");
    }

    private void attemptRecordName(String string, String string2, AutocompletionResult autocompletionResult) {
        if (!string.startsWith(string2)) {
            return;
        }
        if (string.equals("this") || string.startsWith("this$")) {
            return;
        }
        autocompletionResult.add(string);
    }

    private String getUndefinedName(String string) {
        if (string.startsWith("name '") && string.endsWith("' is not defined")) {
            String string2 = string.substring(6, string.length() - 16);
            return string2;
        }
        return null;
    }

    private TypeInfo findCandidateJebApiType(String string) {
        if (this.typeinfoprv == null) {
            return null;
        }
        return this.typeinfoprv.findType(string, true);
    }

    private boolean loadJebApiType(String string) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        ExecutionResult executionResult = this.executeInternal("from " + string2 + " import " + string3, false);
        return executionResult.isSuccess();
    }
}

